/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNodePredicate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PerspectiveTreeNode {
    public PerspectiveTreeNodePayload payload;
    public List<PerspectiveTreeNode> children = new ArrayList<PerspectiveTreeNode>();
    @JsonIgnore
    public PerspectiveTreeNode parent;
    @JsonIgnore
    public boolean requiresChildren;

    public void addChild(PerspectiveTreeNode perspectiveTreeNode) {
        if (perspectiveTreeNode == null) {
            return;
        }
        this.children.add(perspectiveTreeNode);
        perspectiveTreeNode.parent = this;
    }

    public void removeChild(PerspectiveTreeNode perspectiveTreeNode) {
        if (perspectiveTreeNode == null) {
            return;
        }
        Iterator<PerspectiveTreeNode> nodeIterator = this.children.iterator();
        while (nodeIterator.hasNext()) {
            PerspectiveTreeNode child = nodeIterator.next();
            if (!perspectiveTreeNode.equals(child)) continue;
            nodeIterator.remove();
            return;
        }
    }

    public <T> PerspectiveTreeNode find(PerspectiveTreeNodePredicate<T> predicate, T other) {
        ArrayDeque<PerspectiveTreeNode> queue = new ArrayDeque<PerspectiveTreeNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            PerspectiveTreeNode currentNode = (PerspectiveTreeNode)queue.poll();
            if (predicate.test(currentNode, other)) {
                return currentNode;
            }
            if (currentNode == null || currentNode.children == null || currentNode.children.isEmpty()) continue;
            queue.addAll(currentNode.children);
        }
        return null;
    }

    public String toString() {
        return this.payload.extensionId;
    }

    public boolean equals(Object anotherNode) {
        if (!(anotherNode instanceof PerspectiveTreeNode)) {
            return false;
        }
        PerspectiveTreeNode anotherPerspectiveTreeNode = (PerspectiveTreeNode)anotherNode;
        if (anotherPerspectiveTreeNode.payload == null) {
            return false;
        }
        return this.payload.extensionId.equals(anotherPerspectiveTreeNode.payload.extensionId);
    }

    public static class PerspectiveTreeNodePayload {
        public String extensionId;
        public String name;
        public String icon;
    }
}

