/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.mutation;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.h5.perspective.dataservice.DataServiceUtil;
import com.vmware.vsphere.client.h5.perspective.model.PerspectiveBase;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import com.vmware.vsphere.client.h5.perspective.spec.RemovePerspectiveSpec;
import com.vmware.vsphere.client.h5.perspective.util.DomainEntityId;
import com.vmware.vsphere.client.h5.perspective.util.PerspectiveUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerspectiveMutationProvider
implements MutationProvider {
    private static final Log logger = LogFactory.getLog(PerspectiveMutationProvider.class);
    private final PerspectiveService perspectiveService;

    public PerspectiveMutationProvider(PerspectiveService perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public OperationResult add(PerspectiveBase perspective) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = DataServiceUtil.createUri(perspective);
        try {
            PerspectiveBase persistedPerspective = this.perspectiveService.savePerspective(perspective);
            operationResult.result = persistedPerspective;
        }
        catch (Exception e) {
            operationResult.error = PerspectiveUtil.getMethodFault(e);
            logger.error((Object)e);
        }
        return operationResult;
    }

    @type(value="Perspective")
    public OperationResult apply(URI perspectiveUri, PerspectiveBase perspective) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = perspectiveUri;
        try {
            operationResult.result = this.perspectiveService.updatePerspective(perspective);
        }
        catch (Exception e) {
            operationResult.error = PerspectiveUtil.getMethodFault(e);
            logger.error((Object)e);
        }
        return operationResult;
    }

    @type(value="Perspective")
    public OperationResult remove(URI perspectiveUri, RemovePerspectiveSpec dummySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = perspectiveUri;
        try {
            DomainEntityId domainEntityId = DataServiceUtil.getDomainEntityId(perspectiveUri);
            if (domainEntityId == null) {
                logger.error((Object)String.format("Invalid URI '%s'.", perspectiveUri));
                operationResult.error = PerspectiveUtil.getMethodFault(new IllegalArgumentException());
                return operationResult;
            }
            this.perspectiveService.deletePerspective(domainEntityId.getEntityId());
            operationResult.result = true;
        }
        catch (Exception e) {
            operationResult.error = PerspectiveUtil.getMethodFault(e);
            logger.error((Object)e);
        }
        return operationResult;
    }
}

