/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vsphere.client.h5.perspective.model.Identifiable;
import com.vmware.vsphere.client.h5.perspective.model.Principal;
import java.util.UUID;

public class AssignmentBase
implements Identifiable,
Comparable<AssignmentBase> {
    private final String id;
    protected String perspectiveId;
    private Principal assignee;
    private Integer priority;

    protected AssignmentBase(String id, String perspectiveId, Principal assignee, Integer priority) {
        this.id = id;
        this.perspectiveId = perspectiveId;
        this.assignee = assignee;
        this.priority = priority;
    }

    @JsonCreator
    public static AssignmentBase newAssignmentBase(@JsonProperty(value="id") String id, @JsonProperty(value="perspectiveId") String perspectiveId, @JsonProperty(value="assignee") Principal assignee, @JsonProperty(value="priority") Integer priority) {
        if (id == null) {
            return new AssignmentBase(UUID.randomUUID().toString(), perspectiveId, assignee, priority);
        }
        return new AssignmentBase(id, perspectiveId, assignee, priority);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPerspectiveId() {
        return this.perspectiveId;
    }

    public Principal getAssignee() {
        return this.assignee;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String toString() {
        return String.format("[%s] perspective with id '%s' assigned to assignee '%s' with priority '%d'", this.getClass().getSimpleName(), this.getPerspectiveId(), this.getAssignee(), this.getPriority());
    }

    @Override
    public int compareTo(AssignmentBase otherAssignmentBase) {
        if (otherAssignmentBase == null) {
            return 1;
        }
        return Integer.compare(this.getPriority(), otherAssignmentBase.getPriority());
    }

    public static class AssignmentReprioritization {
        private String assignmentId;
        private Integer newPriority;

        @JsonCreator
        public AssignmentReprioritization(@JsonProperty(value="assignmentId") String assignmentId, @JsonProperty(value="newPriority") Integer newPriority) {
            this.assignmentId = assignmentId;
            this.newPriority = newPriority;
        }

        public String getAssignmentId() {
            return this.assignmentId;
        }

        public Integer getNewPriority() {
            return this.newPriority;
        }
    }
}

