/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.dataservice;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.h5.perspective.model.UiRestriction;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNode;
import com.vmware.vsphere.client.h5.perspective.tree.ServerObjectViewExtensionTreeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerspectiveUiPropertyProvider
implements PropertyProviderBean {
    private static final Log logger = LogFactory.getLog(PerspectiveUiPropertyProvider.class);
    private static final String ROOT_EXTENSION = "vsphere.core.inventory.serverObjectViewsExtension";
    private final ServerObjectViewExtensionTreeBuilder serverObjectViewExtensionTreeBuilder;
    private final PerspectiveService perspectiveService;

    public PerspectiveUiPropertyProvider(ServerObjectViewExtensionTreeBuilder serverObjectViewExtensionTreeBuilder, PerspectiveService perspectiveService) {
        this.serverObjectViewExtensionTreeBuilder = serverObjectViewExtensionTreeBuilder;
        this.perspectiveService = perspectiveService;
    }

    @type(value="Folder")
    public PerspectiveTreeNode[] getPerspectiveExtensionTree(ManagedObjectReference vcRootFolder) {
        try {
            PerspectiveTreeNode[] perspectiveTreeRootNodes;
            for (PerspectiveTreeNode treeNode : perspectiveTreeRootNodes = this.serverObjectViewExtensionTreeBuilder.build(ROOT_EXTENSION).toArray(new PerspectiveTreeNode[0])) {
                this.serverObjectViewExtensionTreeBuilder.prune(treeNode);
            }
            return perspectiveTreeRootNodes;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve 'perspectiveExtensionTree'.", (Throwable)e);
            return new PerspectiveTreeNode[0];
        }
    }

    @type(value="Folder")
    public UiRestriction getUiRestrictionForAssignee(ManagedObjectReference vcRootFolder, String assignee) {
        try {
            return this.perspectiveService.loadUiRestrictionForAssignee(assignee);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Failed to load UiRestriction for assignee '%s'", assignee), (Throwable)e);
            return null;
        }
    }
}

