/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.dataservice;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.h5.perspective.dataservice.DataServiceUtil;
import com.vmware.vsphere.client.h5.perspective.model.Identifiable;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import com.vmware.vsphere.client.h5.perspective.util.PerspectiveUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Perspective")
public class PerspectiveDataProviderAdapter
extends DataProviderAdapterBase {
    private static final Log logger = LogFactory.getLog(PerspectiveDataProviderAdapter.class);
    private static final String ALL_PERSPECTIVES_PROPERTY = "perspective";
    private final PerspectiveService perspectiveService;

    public PerspectiveDataProviderAdapter(PerspectiveService perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    protected ResultSet processQuery(PropertyConstraint constraint, QuerySpec parentQuery) {
        if (parentQuery.resourceSpec != null && parentQuery.resourceSpec.propertySpecs != null) {
            for (PropertySpec propertySpec : parentQuery.resourceSpec.propertySpecs) {
                if (!"Perspective".equals(propertySpec.type) || propertySpec.propertyNames.length <= 0) continue;
                ResultSet resultSet = new ResultSet();
                try {
                    Identifiable[] perspectives = this.perspectiveService.loadAllPerspectives();
                    ResultItem[] resultItems = new ResultItem[perspectives.length];
                    resultSet.totalMatchedObjectCount = perspectives.length;
                    resultSet.queryName = parentQuery.name;
                    for (String propertyName : propertySpec.propertyNames) {
                        if (!ALL_PERSPECTIVES_PROPERTY.equals(propertyName)) continue;
                        DataServiceUtil.populateIdentityResultItems(perspectives, propertyName, resultItems);
                    }
                    resultSet.items = resultItems;
                    return resultSet;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return ResultUtil.newErrorResultSet((Exception[])new Exception[]{PerspectiveUtil.getLocalizedException("error.general")});
                }
            }
        }
        return ResultUtil.newEmptyResultSet();
    }
}

