/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.dataservice;

import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vsphere.client.h5.perspective.model.Assignment;
import com.vmware.vsphere.client.h5.perspective.model.AssignmentBase;
import com.vmware.vsphere.client.h5.perspective.model.Identifiable;
import com.vmware.vsphere.client.h5.perspective.model.Perspective;
import com.vmware.vsphere.client.h5.perspective.model.PerspectiveBase;
import com.vmware.vsphere.client.h5.perspective.util.DomainEntityId;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public abstract class DataServiceUtil {
    private static final String DEFAULT_SCOPE_ID_VALUE = "scopeId";
    private static final Map<Class<?>, String> TYPE_TO_RESOURCE_TYPE_INDEX = new HashMap();
    public static final String PERSPECTIVE_TYPE = "Perspective";
    public static final String ASSIGNMENT_TYPE = "Assignment";

    public static ResultItem[] populateIdentityResultItems(Identifiable[] entities, String propertyName, ResultItem[] resultItems) {
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            ResultItem currentResultItem = new ResultItem();
            currentResultItem.properties = new PropertyValue[1];
            URI resourceObject = DataServiceUtil.createUri(entities[i]);
            currentResultItem.properties[0] = ResultUtil.newProperty((String)propertyName, (Object)entities[i], (Object)resourceObject);
            currentResultItem.resourceObject = resourceObject;
            resultItems[i] = currentResultItem;
        }
        return resultItems;
    }

    public static URI createUri(Identifiable resourceObject) {
        String resourceObjectType = DataServiceUtil.getDataServiceTypeForEntity(resourceObject);
        if (resourceObjectType == null) {
            return null;
        }
        DomainEntityId domainEntityId = new DomainEntityId(DEFAULT_SCOPE_ID_VALUE, resourceObject.getId());
        String domainIdStr = domainEntityId.toString();
        if (domainIdStr == null || domainIdStr.isEmpty()) {
            return null;
        }
        return DefaultUriSchemeUtil.createUri((String)resourceObjectType, (String)domainIdStr);
    }

    public static DomainEntityId getDomainEntityId(URI resourceObjectUri) {
        String domainEntityStringId = DefaultUriSchemeUtil.getId((URI)resourceObjectUri);
        if (domainEntityStringId == null) {
            return null;
        }
        return DomainEntityId.fromString(domainEntityStringId);
    }

    private static String getDataServiceTypeForEntity(Object entity) {
        String dsType = TYPE_TO_RESOURCE_TYPE_INDEX.get(entity.getClass());
        if (dsType == null) {
            return "";
        }
        return dsType;
    }

    static {
        TYPE_TO_RESOURCE_TYPE_INDEX.put(PerspectiveBase.class, PERSPECTIVE_TYPE);
        TYPE_TO_RESOURCE_TYPE_INDEX.put(Perspective.class, PERSPECTIVE_TYPE);
        TYPE_TO_RESOURCE_TYPE_INDEX.put(AssignmentBase.class, ASSIGNMENT_TYPE);
        TYPE_TO_RESOURCE_TYPE_INDEX.put(Assignment.class, ASSIGNMENT_TYPE);
    }
}

