/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.cluster.VmComponentProtectionSettings;

public class VmResponseControlModel {
    private DasVmSettings.RestartPriority restartPriority = DasVmSettings.RestartPriority.medium;
    private DasVmSettings.IsolationResponse isolationResponse = DasVmSettings.IsolationResponse.none;
    private VmComponentProtectionSettings.StorageVmReaction vmStorageProtectionForAPD = VmComponentProtectionSettings.StorageVmReaction.disabled;
    private VmComponentProtectionSettings.StorageVmReaction vmStorageProtectionForPDL = VmComponentProtectionSettings.StorageVmReaction.disabled;

    VmResponseControlModel(DasVmSettings defaultSettings) {
        if (defaultSettings != null) {
            this.restartPriority = DasVmSettings.RestartPriority.valueOf((String)defaultSettings.getRestartPriority());
            this.isolationResponse = DasVmSettings.IsolationResponse.valueOf((String)defaultSettings.getIsolationResponse());
            VmComponentProtectionSettings vmcpSettings = defaultSettings.getVmComponentProtectionSettings();
            if (vmcpSettings != null) {
                String apdProtectionLevelString;
                String pdlProtectionLevelString = vmcpSettings.getVmStorageProtectionForPDL();
                if (pdlProtectionLevelString != null) {
                    this.vmStorageProtectionForPDL = VmComponentProtectionSettings.StorageVmReaction.valueOf((String)pdlProtectionLevelString);
                }
                if ((apdProtectionLevelString = vmcpSettings.getVmStorageProtectionForAPD()) != null) {
                    this.vmStorageProtectionForAPD = VmComponentProtectionSettings.StorageVmReaction.valueOf((String)apdProtectionLevelString);
                }
            }
        }
    }

    public DasVmSettings.RestartPriority getRestartPriority() {
        return this.restartPriority;
    }

    public DasVmSettings.IsolationResponse getIsolationResponse() {
        return this.isolationResponse;
    }

    public VmComponentProtectionSettings.StorageVmReaction getVmStorageProtectionForPDL() {
        return this.vmStorageProtectionForPDL;
    }

    public VmComponentProtectionSettings.StorageVmReaction getVmStorageProtectionForAPD() {
        return this.vmStorageProtectionForAPD;
    }
}

