/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.services.DsClusterNameData;
import java.util.ArrayList;
import java.util.List;

@QueryBinding(value="Datastore")
public class HeartbeatDatastoreBaseData
extends IdentifiableQueryBinding {
    @Property(value="Datastore/primaryIconId")
    public String iconId;
    @Property(value="Datastore/name")
    public String name;
    @NestedQueryBinding
    @Relationship(value={"Datastore/parentPod"})
    public DsClusterNameData dsClusterData;
    @Property(value="Datastore/host")
    public transient Datastore.HostMount[] hostMounts;

    protected List<ManagedObjectReference> getAccessibleAndMountedHostsForDatastore() {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])this.hostMounts)) {
            for (Datastore.HostMount hostMount : this.hostMounts) {
                MountInfo mountInfo = hostMount.getMountInfo();
                if (!mountInfo.getAccessible().booleanValue() || !mountInfo.getMounted().booleanValue()) continue;
                result.add(hostMount.getKey());
            }
        }
        return result;
    }
}

