/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolBaseCapacityData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolMemoryReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmMemoryReservationUsersData;
import com.vmware.vsphere.client.clusterui.util.ResourceReservationUtil;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="AnyResourcePool")
public class ResourcePoolMemoryCapacityData
extends ResourcePoolBaseCapacityData {
    @Property(value="AnyResourcePool/config/memoryAllocation/expandableReservation")
    public boolean expandableReservation;
    @Property(value="AnyResourcePool/runtime/memory/unreservedForVm")
    protected long availableCapacity;
    @Property(value="AnyResourcePool/runtime/memory/reservationUsed")
    protected long reservedCapacity;
    @NestedQueryBinding
    @Relationship(value={"AnyResourcePool/vm"})
    protected VmMemoryReservationUsersData[] vms;
    @NestedQueryBinding
    @Relationship(value={"AnyResourcePool/resourcePool"})
    protected ResourcePoolMemoryReservationUsersData[] resourcePools;
    @Property(value="AnyResourcePool/config/memoryAllocation/reservation")
    protected long configuredReservation;

    public String getConfiguredReservationFormatted() {
        return FormatUtil.getDataSizeFormatted((Number)this.configuredReservation, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
    }

    @Override
    public String getRpReservationCapacityFormatted() {
        return Util.getBytesMemoryFormatted(this.getReservationCapacity());
    }

    @Override
    public String getAvailableCapacityFormatted() {
        return Util.getBytesMemoryFormatted(this.availableCapacity);
    }

    @Override
    public String getReservedCapacityFormatted() {
        return Util.getBytesMemoryFormatted(this.reservedCapacity);
    }

    @Override
    protected long getAvailableCapacity() {
        return this.availableCapacity;
    }

    @Override
    protected long getReservedCapacity() {
        return this.reservedCapacity;
    }

    @Override
    protected VmBaseReservationUsersData[] getVms() {
        return ResourceReservationUtil.getVmsMemorySharesValuePercentages(this.vms, this.resourcePools);
    }

    @Override
    protected ResourcePoolBaseReservationUsersData[] getResourcePools() {
        return ResourceReservationUtil.getRpsMemorySharesValuePercentages(this.vms, this.resourcePools);
    }
}

