/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsClusterUtilizationUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.VmUtilizationData;

@QueryBinding(value="VirtualMachine")
public class DrsCpuVmUtilizationData
extends VmUtilizationData {
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    public int overallCpuUsage;
    @Property(value="VirtualMachine/summary/quickStats/overallCpuDemand")
    transient int overallCpuDemand;
    @Property(value="VirtualMachine/summary/quickStats/distributedCpuEntitlement")
    transient int cpuEntitlement;
    public double cpuBarWidth;

    public String getOverallCpuUsageText() {
        return FormatUtil.getFrequencyFormatted((Number)this.overallCpuUsage, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    public String getOverallCpuDemandText() {
        return FormatUtil.getFrequencyFormatted((Number)this.overallCpuDemand, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    public String getCpuEntitlementText() {
        return FormatUtil.getFrequencyFormatted((Number)this.cpuEntitlement, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    public String getCpuEntitlementColor() {
        double entitlement = this.getCpuDelivered();
        return DrsClusterUtilizationUtil.getCpuEntitlementColor(entitlement);
    }

    public int getCpuDeliveredPercentage() {
        return DrsClusterUtilizationUtil.getDeliveredPercentage(this.cpuEntitlement, this.overallCpuUsage);
    }

    private double getCpuDelivered() {
        return Math.min(1.0, this.cpuEntitlement > 0 ? (double)this.overallCpuUsage / (double)this.cpuEntitlement : 0.0);
    }
}

