/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rules.impl;

import com.vmware.vim.binding.vim.cluster.AffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.AntiAffinityRuleSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.cluster.RuleSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.core.model.data;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.cluster.rules.RuleConflictInfo;
import com.vmware.vsphere.client.cluster.rules.RuleInfoEx;
import com.vmware.vsphere.client.cluster.rules.RuleMemberInfo;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ClusterRuleSpecValidator {
    private Map<String, RuleMemberInfo> ruleMembersBySuid = new HashMap<String, RuleMemberInfo>();
    private static final String PROPERTY_CLUSTER_RULES = "configurationEx[@type='ClusterConfigInfoEx'].rule";
    private static final int MAX_RULE_NAME_LENGTH = 80;
    private final DataService _dataService;
    private final ManagedObjectReference _clusterRef;
    private RuleInfo[] _existingRulesCache = null;
    private final RuleSpec _ruleSpec;

    public ClusterRuleSpecValidator(DataService dataService, ManagedObjectReference clusterRef, RuleSpec ruleSpec) throws IllegalArgumentException {
        if (dataService == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("rules.error.dataServiceNotProvided"));
        }
        if (clusterRef == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("rules.error.clusterRuleNotProvided"));
        }
        this._dataService = dataService;
        this._clusterRef = clusterRef;
        this._ruleSpec = ruleSpec;
    }

    public RuleInfoEx[] getConflictsForExistingRules() throws Exception {
        RuleInfo[] rules = this.getClusterRules();
        RuleInfoEx[] ruleInfoEx = this.getConflictsForRules(rules);
        return ruleInfoEx;
    }

    public ValidationResult validateRuleSpec() {
        ValidationResult result = this.checkName();
        if (result.error != null) {
            return result;
        }
        result = this.checkConflicts();
        return result;
    }

    public ValidationResult checkName() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._clusterRef;
        try {
            RuleInfo[] clusterRules;
            if (this._ruleSpec == null || this._ruleSpec.info == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.incorrectValidationSpec"));
            }
            if (StringUtil.isNullOrEmpty((String)this._ruleSpec.info.name)) {
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.nameEmpty"));
            }
            if (this._ruleSpec.info.name.length() > 80) {
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.nameTooLong"));
            }
            for (RuleInfo rule : clusterRules = this.getClusterRules()) {
                if (!StringUtils.equals((String)rule.name, (String)this._ruleSpec.info.name) || rule.key.equals(this._ruleSpec.info.key)) continue;
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.nameNotUnique"));
            }
            validationResult.result = ValidationStatus.SUCCESS;
        }
        catch (Exception e) {
            validationResult.result = ValidationStatus.NAME_ERROR;
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult checkConflicts() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._clusterRef;
        try {
            if (this._ruleSpec == null || this._ruleSpec.info == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.incorrectValidationSpec"));
            }
            RuleInfo[] existingRules = this.getClusterRules();
            if (existingRules == null) {
                validationResult.result = ValidationStatus.SUCCESS;
                return validationResult;
            }
            RuleInfo[] rules = this.mergeRule(existingRules, this._ruleSpec);
            RuleInfoEx[] rulesConflictInfo = this.getConflictsForRules(rules);
            Integer ruleKey = this._ruleSpec.info.key;
            RuleInfoEx ruleOfInterest = null;
            for (RuleInfoEx ruleInfoEx : rulesConflictInfo) {
                if ((ruleInfoEx.rule.key != null || ruleKey != null) && !ruleInfoEx.rule.key.equals(ruleKey)) continue;
                ruleOfInterest = ruleInfoEx;
                break;
            }
            Boolean isCurrentRuleEnabled = this._ruleSpec.info.enabled;
            Boolean isConflictingRuleEnabled = false;
            if (ruleOfInterest != null) {
                for (RuleInfoEx ruleInfoEx : ruleOfInterest.conflictingRules) {
                    if (!ruleInfoEx.rule.enabled.booleanValue()) continue;
                    isConflictingRuleEnabled = true;
                    break;
                }
            }
            if (isCurrentRuleEnabled.booleanValue() && isConflictingRuleEnabled.booleanValue()) {
                throw new IllegalArgumentException(Util.getLocalizedString("rules.error.ruleConflicts"));
            }
            validationResult.result = ValidationStatus.SUCCESS;
        }
        catch (Exception e) {
            validationResult.result = ValidationStatus.RULE_CONFLICT_ERROR;
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    private RuleInfo[] getClusterRules() throws Exception {
        if (this._existingRulesCache == null) {
            this._existingRulesCache = (RuleInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)this._clusterRef, (String)PROPERTY_CLUSTER_RULES);
        }
        this._existingRulesCache = this._existingRulesCache != null ? this._existingRulesCache : new RuleInfo[]{};
        return this._existingRulesCache;
    }

    private RuleInfo[] mergeRule(RuleInfo[] existingRules, RuleSpec ruleToApply) {
        if (ruleToApply == null || ruleToApply.info == null) {
            return existingRules;
        }
        RuleInfo[] rules = new RuleInfo[]{};
        switch (ruleToApply.operation) {
            case add: {
                int existingRulesCount = existingRules.length;
                rules = new RuleInfo[existingRulesCount + 1];
                System.arraycopy(existingRules, 0, rules, 0, existingRulesCount);
                rules[existingRulesCount] = ruleToApply.info;
                break;
            }
            case edit: {
                int ruleIndex = 0;
                for (RuleInfo rule : existingRules) {
                    if (rule.key.equals(ruleToApply.info.key)) break;
                    ++ruleIndex;
                }
                existingRules[ruleIndex] = ruleToApply.info;
                rules = existingRules;
                break;
            }
        }
        return rules;
    }

    public RuleInfoEx[] getConflictsForRules(RuleInfo[] rules) throws IllegalArgumentException {
        if (rules == null) {
            return new RuleInfoEx[0];
        }
        RuleInfoEx[] returnArray = new RuleInfoEx[rules.length];
        this.ruleMembersBySuid.clear();
        for (int i = 0; i < rules.length; ++i) {
            RuleInfoEx rule = RuleInfoEx.createFromRuleInfo(rules[i]);
            ManagedObjectReference[] vms = this.getVirtualMachineMembers(rule.rule);
            if (vms != null) {
                rule.members = this.getRuleMembersForRule(vms, rule);
            }
            returnArray[i] = rule;
        }
        this.addRuleConflictData(returnArray);
        return returnArray;
    }

    private ManagedObjectReference[] getVirtualMachineMembers(RuleInfo rule) {
        if (rule instanceof AffinityRuleSpec) {
            return ((AffinityRuleSpec)rule).vm;
        }
        if (rule instanceof AntiAffinityRuleSpec) {
            return ((AntiAffinityRuleSpec)rule).vm;
        }
        return null;
    }

    private ArrayList<RuleMemberInfo> getRuleMembersForRule(ManagedObjectReference[] vms, RuleInfoEx rule) {
        ArrayList<RuleMemberInfo> members = new ArrayList<RuleMemberInfo>(vms.length);
        for (ManagedObjectReference vm : vms) {
            RuleMemberInfo member = this.getRuleMember(vm);
            member.rules.add(rule);
            members.add(member);
        }
        return members;
    }

    private RuleMemberInfo getRuleMember(ManagedObjectReference vm) {
        RuleMemberInfo member = this.ruleMembersBySuid.get(vm.toString());
        if (member == null) {
            member = RuleMemberInfo.createInstance(vm);
            this.ruleMembersBySuid.put(vm.toString(), member);
        }
        return member;
    }

    private void addRuleConflictData(RuleInfoEx[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            RuleInfoEx rule1 = rules[i];
            if (!(rule1.rule instanceof AffinityRuleSpec) && !(rule1.rule instanceof AntiAffinityRuleSpec)) continue;
            for (int j = i + 1; j < rules.length; ++j) {
                this.addConflictDataForRulePair(rule1, rules[j]);
            }
        }
    }

    private void addConflictDataForRulePair(RuleInfoEx rule1, RuleInfoEx rule2) {
        if (rule1.rule instanceof AffinityRuleSpec) {
            if (rule2.rule instanceof AffinityRuleSpec) {
                this.addAffinityAffinityConflicts(rule1, rule2);
            } else if (rule2.rule instanceof AntiAffinityRuleSpec) {
                this.addAffinityAntiAffinityConflcits(rule1, rule2);
            }
        } else if (rule1.rule instanceof AntiAffinityRuleSpec) {
            if (rule2.rule instanceof AffinityRuleSpec) {
                this.addAffinityAntiAffinityConflcits(rule2, rule1);
            } else if (rule2.rule instanceof AntiAffinityRuleSpec) {
                this.addAntiAffinityAntiAffinityConflicts(rule1, rule2);
            }
        }
    }

    private void addAffinityAffinityConflicts(RuleInfoEx rule1, RuleInfoEx rule2) {
        boolean conflictFound = false;
        for (RuleMemberInfo member : rule1.members) {
            if (!ClusterRuleSpecValidator.containsMember(rule2, member).booleanValue()) continue;
            conflictFound = true;
            RuleConflictInfo conflictInfo = RuleConflictInfo.createInstance(RuleConflictInfo.ConflictType.AFFINITY_AFFINITY);
            conflictInfo.rule1 = rule1;
            conflictInfo.rule2 = rule2;
            conflictInfo.members = new RuleMemberInfo[]{member};
            member.conflicts.add(conflictInfo);
        }
        if (conflictFound) {
            rule1.conflictingRules.add(rule2);
            rule2.conflictingRules.add(rule1);
        }
    }

    private void addAffinityAntiAffinityConflcits(RuleInfoEx affinityRule, RuleInfoEx antiAffinityRule) {
        ArrayList<RuleMemberInfo> intersection = new ArrayList<RuleMemberInfo>();
        for (RuleMemberInfo member : affinityRule.members) {
            if (!ClusterRuleSpecValidator.containsMember(antiAffinityRule, member).booleanValue()) continue;
            intersection.add(member);
        }
        if (intersection.size() > 1) {
            RuleConflictInfo conflictInfo = RuleConflictInfo.createInstance(RuleConflictInfo.ConflictType.AFFINITY_ANTIAFFINITY);
            conflictInfo.rule1 = affinityRule;
            conflictInfo.rule2 = antiAffinityRule;
            conflictInfo.members = intersection.toArray(new RuleMemberInfo[intersection.size()]);
            for (RuleMemberInfo member : intersection) {
                member.conflicts.add(conflictInfo);
            }
            affinityRule.conflictingRules.add(antiAffinityRule);
            antiAffinityRule.conflictingRules.add(affinityRule);
        }
    }

    private void addAntiAffinityAntiAffinityConflicts(RuleInfoEx rule1, RuleInfoEx rule2) {
        int intersection = 0;
        for (RuleMemberInfo member : rule1.members) {
            if (!ClusterRuleSpecValidator.containsMember(rule2, member).booleanValue()) continue;
            ++intersection;
        }
        if (intersection == rule1.members.size() || intersection == rule2.members.size()) {
            rule1.conflictingRules.add(rule2);
            rule2.conflictingRules.add(rule1);
        }
    }

    private static Boolean containsMember(RuleInfoEx ruleInfoEx, RuleMemberInfo memberInfo) {
        if (ruleInfoEx == null || ruleInfoEx.members == null || memberInfo == null) {
            return false;
        }
        for (RuleMemberInfo member : ruleInfoEx.members) {
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)memberInfo.entity, (ManagedObjectReference)member.entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @data
    public static enum ValidationStatus {
        SUCCESS,
        NAME_ERROR,
        RULE_CONFLICT_ERROR;

    }
}

