/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.cluster.rp.ClusterDataModel;
import com.vmware.vsphere.client.cluster.rp.Constants;
import com.vmware.vsphere.client.cluster.rp.LogUtil;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RpDataModel;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpTreeSnapshotter {
    private static final Log _logger = LogFactory.getLog(RpTreeSnapshotter.class);
    private final DataFetchCommand _dataFetchCommand;

    public RpTreeSnapshotter(DataFetchCommand dataFetchCommand) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataFetchCommand});
        this._dataFetchCommand = dataFetchCommand;
    }

    public MorTree<ManagedObjectReference, RpInfo> snaphotRpTree(ManagedObjectReference clusterRef) throws Exception {
        RpDataModel parentRpData;
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef});
        ClusterDataModel clusterData = this.getDataModel(ClusterDataModel.class, clusterRef);
        ManagedObjectReference rootRpRef = clusterData.rootRpRef;
        RpDataModel rootRpData = this.getDataModel(RpDataModel.class, rootRpRef);
        MorTree<ManagedObjectReference, RpInfo> rpTree = new MorTree<ManagedObjectReference, RpInfo>();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Creating RP tree snapshot: " + rpTree + " for cluster: " + clusterRef));
        }
        rpTree.setMetadata(clusterRef);
        rpTree.setRootMor(rootRpRef);
        LinkedList<RpDataModel> rpDataQueue = new LinkedList<RpDataModel>();
        rpDataQueue.add(rootRpData);
        rpTree.putInfo(rootRpRef, new RpInfo());
        while ((parentRpData = (RpDataModel)((Object)rpDataQueue.poll())) != null) {
            Collection childRpDataModels = this._dataFetchCommand.execute(RpDataModel.class, (Object[])parentRpData.childRps);
            for (RpDataModel childRpData : childRpDataModels) {
                ManagedObjectReference parentRef = (ManagedObjectReference)parentRpData.provider;
                ManagedObjectReference childRef = (ManagedObjectReference)childRpData.provider;
                rpTree.addChild(parentRef, childRef);
                RpInfo rpInfo = new RpInfo(childRpData);
                rpTree.putInfo(childRef, rpInfo);
                rpDataQueue.add(childRpData);
                if (!_logger.isInfoEnabled()) continue;
                _logger.info((Object)("Added child RP: " + childRef + " with config: " + LogUtil.toString(rpInfo) + " for parent RP: " + parentRef + " in RP tree snapshot: " + rpTree));
            }
        }
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("RP tree snapshot: " + rpTree + " created successfully for cluster: " + clusterRef));
        }
        return rpTree;
    }

    public void restoreRpTree(final MorTree<ManagedObjectReference, RpInfo> rpTree) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{rpTree});
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Resotring RP tree snapshot: " + rpTree + " for cluster: " + rpTree.getMetadata()));
        }
        final ManagedObjectReference rootRpRef = rpTree.getRootMor();
        RpDataModel rootRpData = this.getDataModel(RpDataModel.class, rootRpRef);
        ManagedObjectReference[] presentVms = rootRpData.vms;
        final HashSet<ManagedObjectReference> presentVmsSet = new HashSet<ManagedObjectReference>();
        for (ManagedObjectReference vmMor : presentVms) {
            presentVmsSet.add(vmMor);
        }
        final HashMap<ManagedObjectReference, ManagedObjectReference> oldToNewMorMap = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        oldToNewMorMap.put(rootRpRef, rootRpRef);
        rpTree.traverse(new MorTree.Visitor<RpInfo>(){

            @Override
            public boolean visit(ManagedObjectReference mor, RpInfo info, List<ManagedObjectReference> children) throws Exception {
                ManagedObjectReference newRpRef = (ManagedObjectReference)oldToNewMorMap.get(mor);
                ResourcePool parentRp = (ResourcePool)RpTreeSnapshotter.this.getManagedObject(newRpRef);
                for (ManagedObjectReference childRpRef : children) {
                    RpInfo childRpInfo = (RpInfo)rpTree.getInfo(childRpRef);
                    String childRpName = childRpInfo.getName();
                    ManagedObjectReference newChildRpRef = parentRp.createResourcePool(childRpName, Constants.EMPTY_RESOURCE_CONFIG_SPEC);
                    oldToNewMorMap.put(childRpRef, newChildRpRef);
                    if (!_logger.isInfoEnabled()) continue;
                    _logger.info((Object)("Created new RP: " + newChildRpRef + " under parent RP: " + parentRp + " from RP tree snapshot: " + rpTree));
                }
                List<ManagedObjectReference> vmRefs = info.getVms();
                Iterator<ManagedObjectReference> it = vmRefs.iterator();
                while (it.hasNext()) {
                    if (presentVmsSet.contains(it.next())) continue;
                    it.remove();
                }
                if (vmRefs.size() > 0) {
                    ManagedObjectReference[] vmRefArr = new ManagedObjectReference[vmRefs.size()];
                    int i = 0;
                    Iterator<ManagedObjectReference> iterator = vmRefs.iterator();
                    while (iterator.hasNext()) {
                        ManagedObjectReference vmRef;
                        vmRefArr[i] = vmRef = iterator.next();
                        ++i;
                    }
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Moving VMs: " + vmRefArr + " under RP: " + parentRp + " from RP tree snapshot: " + rpTree));
                    }
                    parentRp.moveInto(vmRefArr);
                }
                return true;
            }
        });
        rpTree.traverse(new MorTree.Visitor<RpInfo>(){

            @Override
            public boolean visit(ManagedObjectReference mor, RpInfo info, List<ManagedObjectReference> children) throws Exception {
                if (!mor.equals((Object)rootRpRef)) {
                    ManagedObjectReference newRpRef = (ManagedObjectReference)oldToNewMorMap.get(mor);
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Updating RP: " + newRpRef + " with config: " + LogUtil.toString(info) + " from RP tree snapshot: " + rpTree));
                    }
                    ResourcePool newRp = (ResourcePool)RpTreeSnapshotter.this.getManagedObject(newRpRef);
                    ResourceConfigSpec resourceConfigSpec = info.getConfigSpec();
                    resourceConfigSpec.setChangeVersion(null);
                    resourceConfigSpec.setEntity(newRpRef);
                    newRp.updateConfig(null, resourceConfigSpec);
                }
                return true;
            }
        });
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("RP tree snapshot: " + rpTree + " restored successfully for cluster: " + rpTree.getMetadata()));
        }
    }

    protected <T extends ManagedObject> T getManagedObject(ManagedObjectReference mor) throws Exception {
        return (T)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
    }

    private <T extends DataModel> T getDataModel(Class<T> modelClass, ManagedObjectReference ref) throws Exception {
        assert (modelClass != null);
        assert (ref != null);
        T dataModel = Util.getDataModel(modelClass, ref, this._dataFetchCommand);
        if (dataModel == null) {
            throw new Exception("Error retrieving data for object: " + ref);
        }
        return dataModel;
    }
}

