/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(TransferPropertyProvider.class);
    private final SsoService _ssoService;
    private final LookupService _lookupService;

    public TransferPropertyProvider(SsoService ssoService, LookupService lookupService) {
        Validate.notNull((Object)ssoService, (String)"SSO service null");
        Validate.notNull((Object)lookupService, (String)"Lookup service null");
        this._ssoService = ssoService;
        this._lookupService = lookupService;
    }

    @type(value="*")
    public URI getVApiRestEndpoint(Object dummyContextItem) throws Exception {
        String endpointType = "com.vmware.vapi.endpoint";
        String endpointProtocol = "vapi.rest.https";
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setNodeId(LookupUtil.getLocalHostLduGuid((LookupService)this._lookupService));
        filter.setEndpointType(new ServiceRegistration.EndpointType("vapi.rest.https", "com.vmware.vapi.endpoint"));
        filter.searchAllSsoDomains = false;
        ServiceRegistration.Info[] searchResult = this._lookupService.getServiceRegistrationInfos(filter);
        ServiceRegistration.Endpoint endpoint = null;
        if (searchResult.length > 0) {
            ServiceRegistration.Info transferPropertyProviderServiceVersion = searchResult[0];
            endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)transferPropertyProviderServiceVersion, (String)"com.vmware.vapi.endpoint");
        }
        if (endpoint == null) {
            _logger.error((Object)("Unable to obtain vApi endpoint of type 'com.vmware.vapi.endpoint' and protocol 'vapi.rest.https' from Lookup Service. Search returned:\n" + ObjectUtil.prettyPrint((Object)searchResult)));
            String message = ProvisioningServiceUtil.getLocalizedString("error.cmVapiRestEndpoint");
            throw new Error(message);
        }
        _logger.debug((Object)("Url retrived from lookup service : " + endpoint.getUrl().toString()));
        return endpoint.getUrl();
    }

    @type(value="*")
    public String getVApiRestAuthToken(Object dummyContextItem) {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        SamlToken ssoToken = AuthSessionUtil.getSsoToken((SsoDomain)ssoDomain);
        if (ssoToken == null) {
            _logger.error((Object)"No SSO token in session");
            return "";
        }
        if (!ssoToken.isDelegable()) {
            _logger.error((Object)"Session SSO token is not delegable");
            return "";
        }
        SamlToken bearerToken = this.getBearerToken(ssoToken);
        if (bearerToken == null) {
            return "";
        }
        String encodedToken = "";
        String tokenXml = bearerToken.toXml();
        byte[] tokenBytes = tokenXml.getBytes();
        ByteArrayOutputStream bufferStream = null;
        GZIPOutputStream compressorStream = null;
        try {
            bufferStream = new ByteArrayOutputStream(tokenBytes.length);
            compressorStream = new GZIPOutputStream(bufferStream);
            compressorStream.write(tokenBytes);
            compressorStream.close();
            byte[] gzipedToken = bufferStream.toByteArray();
            encodedToken = new String(Base64.encodeBase64((byte[])gzipedToken));
        }
        catch (IOException error) {
            this.tryClose(bufferStream);
            this.tryClose(compressorStream);
            _logger.error((Object)"Error packaging SAML token.", (Throwable)error);
        }
        return encodedToken;
    }

    private SamlToken getBearerToken(SamlToken sourceToken) {
        assert (sourceToken != null) : "sourceToken null";
        ConfirmationType type2 = sourceToken.getConfirmationType();
        if (ConfirmationType.BEARER.equals((Object)type2)) {
            _logger.debug((Object)"Token is a already bearer token. Returning original.");
            return sourceToken;
        }
        SamlToken result = null;
        try {
            long lifetime = (sourceToken.getExpirationTime().getTime() - sourceToken.getStartTime().getTime()) / 1000L;
            TokenSpec.Builder builder = new TokenSpec.Builder(lifetime);
            TokenSpec tokenSpec = builder.confirmation(TokenSpec.Confirmation.NONE).renewable(sourceToken.isRenewable()).delegationSpec(new TokenSpec.DelegationSpec(true)).createTokenSpec();
            SamlToken cloneToken = this._ssoService.acquireTokenByToken(sourceToken, tokenSpec);
            ConfirmationType clonedTokenType = cloneToken.getConfirmationType();
            if (ConfirmationType.BEARER.equals((Object)clonedTokenType)) {
                result = cloneToken;
            } else {
                _logger.error((Object)("Attempts to acquire bearer token from token " + sourceToken.toString() + " of type " + type2 + " failed. The new token type is " + clonedTokenType));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception acquiring bearer token from existing token.", (Throwable)ex);
        }
        return result;
    }

    private void tryClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable error) {
                _logger.error((Object)"Exception closing stream", error);
            }
        }
    }
}

