/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.content.library.Item;
import com.vmware.content.library.ItemModel;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vcenter.ovf.ExportSession;
import com.vmware.vcenter.ovf.ExportSessionTypes;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.provisioning.spec.AddToLibrarySpec;
import com.vmware.vsphere.client.provisioning.spec.OvfDownloadSessionSpec;
import com.vmware.vsphere.client.provisioning.util.OvfExportSessionUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningContentLibraryMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ProvisioningContentLibraryMutationProvider.class);
    private static final long DOWNLOAD_SESSION_READY_TIMEOUT = 60000L;
    private static final long EXPORT_SESSION_STATE_POLL_INTERVAL = 2000L;
    private final ExportSession _exportSession;
    private final Item _libraryItemService;
    private VapiTaskMonitor _vapiTaskMonitor;

    public ProvisioningContentLibraryMutationProvider(ExportSession exportSession, Item libraryItemService) {
        this._exportSession = exportSession;
        this._libraryItemService = libraryItemService;
    }

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public OperationResult apply(ManagedObjectReference objRef, AddToLibrarySpec spec) {
        OperationResult result = new OperationResult();
        assert (objRef != null);
        assert (spec != null);
        assert (spec.contentLibrary != null);
        assert (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualApp.class));
        if (this.isUriEmpty(spec.libraryItem)) {
            result.entity = spec.contentLibrary;
        } else {
            result.entity = spec.libraryItem;
            this.editLibraryItemDetails(spec);
        }
        ExportSessionTypes.SourceInfo sourceInfo = new ExportSessionTypes.SourceInfo();
        String objId = CisIdConverter.toGlobalCisId((ManagedObjectReference)objRef, (String)objRef.getServerGuid());
        Boolean isVmReference = ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class);
        if (isVmReference.booleanValue()) {
            sourceInfo.setVmId(objId);
        } else {
            sourceInfo.setVappId(objId);
        }
        ExportSessionTypes.CreateSpec exportParameters = this.createAddToLibraryExportParamsSpec(spec);
        try {
            VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
            _logger.info((Object)String.format("Initiating export session for object: %s. Client token: %s", objId, asyncCallback.getActivationId()));
            this._exportSession.create(asyncCallback.getActivationId(), sourceInfo, (Structure)exportParameters, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
            _logger.info((Object)("Create export session task: " + ObjectUtil.prettyPrint((Object)result.task)));
        }
        catch (Exception e) {
            _logger.error((Object)("Could not create export session. spec =  " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    private void editLibraryItemDetails(AddToLibrarySpec spec) {
        String libraryItemId = UriSchemeUtil.getId((URI)spec.libraryItem);
        ItemModel libraryItem = new ItemModel();
        if (!StringUtil.isNullOrEmpty((String)spec.name)) {
            libraryItem.setName(spec.name);
        }
        if (spec.description != null) {
            libraryItem.setDescription(spec.description);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating update library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryItemService.update(libraryItemId, libraryItem, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit library item operation failed", (Throwable)e);
        }
    }

    private ExportSessionTypes.CreateSpec createAddToLibraryExportParamsSpec(AddToLibrarySpec spec) {
        ExportSessionTypes.CreateSpec createItemSpec = new ExportSessionTypes.CreateSpec();
        if (!this.isUriEmpty(spec.contentLibrary)) {
            createItemSpec.setContentLibrary(UriSchemeUtil.getId((URI)spec.contentLibrary));
        }
        if (!this.isUriEmpty(spec.libraryItem)) {
            createItemSpec.setContentLibraryItem(UriSchemeUtil.getId((URI)spec.libraryItem));
        }
        createItemSpec.setName(spec.name);
        createItemSpec.setDescription(spec.description);
        createItemSpec.setTargetType(ExportSessionTypes.TargetType.CONTENT_LIBRARY_TARGET);
        List<Object> exportFlags = new ArrayList();
        if (spec.exportFlags != null && spec.exportFlags.length > 0) {
            exportFlags = Arrays.asList(spec.exportFlags);
        }
        createItemSpec.setExportFlags(exportFlags);
        return createItemSpec;
    }

    public OperationResult apply(ManagedObjectReference entity, OvfDownloadSessionSpec spec) {
        Validate.notNull((Object)((Object)spec), (String)"null spec");
        Validate.notNull((Object)entity, (String)"null entity");
        Validate.isTrue((ManagedObjectUtil.isOfType((ManagedObjectReference)entity, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)entity, VirtualApp.class) ? 1 : 0) != 0);
        OperationResult result = new OperationResult();
        ExportSessionTypes.CreateSpec exportParameters = this.createDownloadSessionParameters(spec);
        ExportSessionTypes.SourceInfo sourceInfo = OvfExportSessionUtil.getSourceInfo(entity);
        String clientToken = VapiUtil.newClientToken();
        try {
            _logger.debug((Object)("Creating export session for downloading " + entity));
            String sessionId = this._exportSession.create(clientToken, sourceInfo, (Structure)exportParameters);
            _logger.debug((Object)("Created export session " + sessionId));
            boolean sessionReady = this.waitForExportSessionState(sessionId, ExportSessionTypes.State.EXPORT_READY, 60000L);
            if (sessionReady) {
                result.result = sessionId;
            } else {
                result.error = new Exception("Timeout waiting for session to become ready");
                _logger.error((Object)("Export session " + sessionId + " failed to reach " + ExportSessionTypes.State.EXPORT_READY + " state. Deleting session."));
                this._exportSession.delete(sessionId);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception creating download session from spec: " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    private boolean waitForExportSessionState(String sessionId, ExportSessionTypes.State goalState, long timeoutMs) {
        long startTime = System.currentTimeMillis();
        long timeElapsedMs = 0L;
        ExportSessionTypes.State currentState = this._exportSession.get(sessionId).getState();
        while (!goalState.equals((Object)currentState) && timeElapsedMs < timeoutMs) {
            BlockingUtil.sleep((long)2000L);
            currentState = this._exportSession.get(sessionId).getState();
            timeElapsedMs = System.currentTimeMillis() - startTime;
        }
        return goalState.equals((Object)currentState);
    }

    private ExportSessionTypes.CreateSpec createDownloadSessionParameters(OvfDownloadSessionSpec spec) {
        ExportSessionTypes.CreateSpec result = new ExportSessionTypes.CreateSpec();
        result.setName(spec.name);
        result.setDescription(spec.description);
        result.setTargetType(ExportSessionTypes.TargetType.DOWNLOAD_TARGET);
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.exportFlags)) {
            result.setExportFlags(Arrays.asList(spec.exportFlags));
        }
        return result;
    }

    private boolean isUriEmpty(URI uri) {
        return uri == null || uri.toString().length() == 0;
    }
}

