/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.Policy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LightWeightCopier {
    private static final Log _logger = LogFactory.getLog(LightWeightCopier.class);

    private LightWeightCopier() {
    }

    public static Object copy(Object original) {
        if (original == null) {
            return null;
        }
        if (original instanceof Policy) {
            return original;
        }
        try {
            return LightWeightCopier.copyShallow(original);
        }
        catch (Exception exc) {
            _logger.error((Object)("Copying " + original.toString() + " failed"), (Throwable)exc);
            return original;
        }
    }

    private static Object copyShallow(Object original) throws Exception {
        Field[] fields;
        if (original == null) {
            return null;
        }
        Object result = LightWeightCopier.construct(original);
        for (Field field : fields = original.getClass().getFields()) {
            if (LightWeightCopier.skipField(field).booleanValue()) continue;
            if (LightWeightCopier.nullifyField(field).booleanValue()) {
                field.set(result, null);
                continue;
            }
            field.set(result, field.get(original));
        }
        return result;
    }

    private static Boolean skipField(Field field) {
        if (field == null) {
            return true;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers)) {
            return true;
        }
        return false;
    }

    private static Boolean nullifyField(Field field) {
        Class<?> clazz = field.getType();
        if (LightWeightCopier.isPolicyArrayClass(clazz).booleanValue()) {
            return false;
        }
        if (clazz.isArray()) {
            return true;
        }
        if (!clazz.isPrimitive() && !LightWeightCopier.isBuiltInType(clazz).booleanValue()) {
            return true;
        }
        return false;
    }

    private static Boolean isPolicyArrayClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> componentClazz = clazz.getComponentType();
        if (!Policy.class.isAssignableFrom(componentClazz)) {
            return false;
        }
        return true;
    }

    private static Boolean isBuiltInType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(String.class);
    }

    private static Object construct(Object original) throws Exception {
        if (original == null) {
            return null;
        }
        Object copy = null;
        Class<?> clazz = original.getClass();
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        copy = ctor.newInstance(new Object[0]);
        return copy;
    }
}

