/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostProfileKillSwitchPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(HostProfileKillSwitchPropertyProvider.class);
    private final FeatureStateService _featureStateService;

    public HostProfileKillSwitchPropertyProvider(FeatureStateService featureStateService) {
        this._featureStateService = featureStateService;
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getIsBulkAnswerFileEnabled(ManagedObjectReference mor) {
        return this.isEntityFromVc65OrLater(mor);
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getIsCompositeHostProfileEnabled(ManagedObjectReference mor) {
        return this.isEntityFromVc65OrLater(mor);
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getIsParallelOperationsEnabled(ManagedObjectReference mor) {
        return this.isEntityFromVc65OrLater(mor);
    }

    private boolean isEntityFromVc65OrLater(ManagedObjectReference mor) {
        try {
            return HostProfileUtils.isVc65OrLater(mor);
        }
        catch (Exception e) {
            _logger.error((Object)"Can't detect the version of the VC entity: ", (Throwable)e);
            return false;
        }
    }
}

