/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.cluster.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.profile.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;

public class Util {
    public static String HOST_PROFILE_SERVICE_STRINGS = "HostProfileService";

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)HOST_PROFILE_SERVICE_STRINGS, (String)key, (ClassLoader)Util.class.getClassLoader());
    }

    public static ServiceInstanceContent getServiceInstanceContent(ManagedObjectReference moRef) {
        VcService vc = VimSessionUtil.getService((String)moRef.getServerGuid());
        return vc.getServiceInstanceContent();
    }

    public static ManagedObjectReference findAssociatedClusterProfile(ServiceInstanceContent serviceContent, ManagedObjectReference clusterRef) throws Exception {
        ManagedObjectReference managerRef = serviceContent.getClusterProfileManager();
        if (managerRef == null) {
            return null;
        }
        return Util.findAssociatedProfile(clusterRef, managerRef);
    }

    public static ManagedObjectReference findAssociatedHostProfile(ServiceInstanceContent serviceContent, ManagedObjectReference clusterRef) throws Exception {
        ManagedObjectReference managerRef = serviceContent.getHostProfileManager();
        if (managerRef == null) {
            return null;
        }
        return Util.findAssociatedProfile(clusterRef, managerRef);
    }

    public static ManagedObjectReference findAssociatedProfile(ManagedObjectReference moRef, ManagedObjectReference managerRef) throws Exception {
        ProfileManager profileManager = (ProfileManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
        ManagedObjectReference[] profileRefs = profileManager.findAssociatedProfile(moRef);
        if (profileRefs != null && profileRefs.length > 0) {
            assert (profileRefs.length == 1);
            return profileRefs[0];
        }
        return null;
    }

    public static ManagedObjectReference[] getHostsForCluster(ManagedObjectReference moRef) {
        VcService vc = VimSessionUtil.getService((String)moRef.getServerGuid());
        ClusterComputeResource cluster = (ClusterComputeResource)vc.getManagedObject(moRef);
        return cluster.getHost();
    }
}

