/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskInfo;
import com.vmware.vim.binding.vim.scheduler.TaskScheduler;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.scheduling.ScheduledTaskExecutionInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduledOpsSearchProvider
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ScheduledOpsSearchProvider.class);
    private static final long MAX_EXECUTION_INFO_LENGTH = 5L;
    private static String PROPERTY_HOST_FOLDER = "hostFolder";
    private static String PROPERTY_VM_FOLDER = "vmFolder";
    private static String PROPERTY_NETWORK_FOLDER = "networkFolder";
    private static String PROPERTY_STORAGE_FOLDER = "datastoreFolder";
    private static String PROPERTY_SCHEDULED_TASK = "scheduledTask";
    private DataService _dataService = null;
    private final TaskSearchHelper _taskSearchHelper;

    public ScheduledOpsSearchProvider(DataServiceExtensionRegistry registry, DataService dataService, TaskSearchHelper taskSearchHelper) {
        registry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
        _logger.debug((Object)"Instance created");
        this._dataService = dataService;
        this._taskSearchHelper = taskSearchHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getData(RequestSpec request) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            QuerySpec query = querySpecs[i];
            try {
                resultSets[i] = this.processQuery(query);
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)"Error retrieving scheduled operation info:", (Throwable)e);
                resultSets[i] = this.processException(e);
                continue;
            }
            finally {
                if (resultSets[i] != null) {
                    resultSets[i].queryName = query.name;
                }
            }
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    private String[] getProvidedTypes() {
        String[] types = new String[]{"vsphere:ScheduledTask", "ScheduledTask"};
        return types;
    }

    private ResultSet processException(Exception e) {
        ResultSet result = new ResultSet();
        result.totalMatchedObjectCount = 0;
        result.error = e;
        return result;
    }

    private ResultSet processQuery(QuerySpec query) throws Exception {
        if (query.resourceSpec == null) {
            return this.newEmptyResultSet();
        }
        Constraint constraint = query.resourceSpec.constraint;
        if (constraint instanceof ObjectIdentityConstraint) {
            return this.processObjectIdentityQuery(query);
        }
        if (constraint instanceof RelationalConstraint) {
            return this.processRelationalQuery(query);
        }
        return null;
    }

    ResultSet processObjectIdentityQuery(QuerySpec query) throws Exception {
        ObjectIdentityConstraint constraint = (ObjectIdentityConstraint)query.resourceSpec.constraint;
        if (!(constraint.target instanceof ManagedObjectReference)) {
            return this.newEmptyResultSet();
        }
        ManagedObjectReference entity = (ManagedObjectReference)constraint.target;
        PropertySpec[] props = query.resourceSpec.propertySpecs;
        String targetType = query.resourceSpec.constraint.targetType;
        if (!"vsphere:ScheduledTask".equals(targetType)) {
            return this.newEmptyResultSet();
        }
        return this.processScheduledTaskQuery(entity, props);
    }

    private List<ManagedObjectReference> getScheduledTasks(ManagedObjectReference entity) throws Exception {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        List<Object> taskRefs = new ArrayList();
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)entity)) {
            taskRefs = this.getAllVcScheduledTasks(entity.getServerGuid());
        } else {
            Object[] entityTasks = (Object[])QueryUtil.getProperty((DataService)this._dataService, (Object)entity, (String)PROPERTY_SCHEDULED_TASK);
            ArrayUtil.append(taskRefs, (Object[])entityTasks);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, Datacenter.class)) {
            ResultSet rs = this.getScheduledTaskForDCInventoryFolders(entity);
            for (ResultItem ri : rs.items) {
                for (PropertyValue prop : ri.properties) {
                    Object[] inventoryFoldersTasks = (Object[])prop.value;
                    ArrayUtil.append(taskRefs, (Object[])inventoryFoldersTasks);
                }
            }
        }
        ArrayUtil.append(result, taskRefs);
        return result;
    }

    private ResultSet getScheduledTaskForDCInventoryFolders(ManagedObjectReference datacenter) throws Exception {
        ObjectIdentityConstraint dcOC = QueryUtil.createObjectIdentityConstraint((Object)datacenter);
        RelationalConstraint hostFolderRC = QueryUtil.createRelationalConstraint((String)PROPERTY_HOST_FOLDER, (Constraint)dcOC, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint vmFolderRC = QueryUtil.createRelationalConstraint((String)PROPERTY_VM_FOLDER, (Constraint)dcOC, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint networkFolderRC = QueryUtil.createRelationalConstraint((String)PROPERTY_NETWORK_FOLDER, (Constraint)dcOC, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint datastoreFolderRC = QueryUtil.createRelationalConstraint((String)PROPERTY_STORAGE_FOLDER, (Constraint)dcOC, (Boolean)true, (String)Folder.class.getSimpleName());
        Constraint[] constraints = new Constraint[]{hostFolderRC, vmFolderRC, networkFolderRC, datastoreFolderRC};
        Constraint inventoryFoldersCC = QueryUtil.combineIntoSingleConstraint((Constraint[])constraints, (Conjoiner)Conjoiner.OR);
        QuerySpec scheduledTasksQS = QueryUtil.buildQuerySpec((Constraint)inventoryFoldersCC, (String[])new String[]{PROPERTY_SCHEDULED_TASK});
        return QueryUtil.getData((DataService)this._dataService, (QuerySpec)scheduledTasksQS);
    }

    private List<Object> getAllVcScheduledTasks(String serverGuid) throws Exception {
        ResultItem[] items;
        ArrayList<Object> result = new ArrayList<Object>();
        Constraint constraint = new Constraint();
        constraint.targetType = "ScheduledTask";
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"name"});
        ResultSet rs = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (rs != null && (items = rs.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                ManagedObjectReference task = (ManagedObjectReference)item.resourceObject;
                if (!task.getServerGuid().equals(serverGuid)) continue;
                result.add(task);
            }
        }
        return result;
    }

    private com.vmware.vise.core.model.scheduling.ScheduledTaskInfo newPlatformScheduledTaskInfo(ScheduledTaskInfo taskInfo) {
        com.vmware.vise.core.model.scheduling.ScheduledTaskInfo result = new com.vmware.vise.core.model.scheduling.ScheduledTaskInfo();
        result.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)taskInfo.name);
        result.description = taskInfo.description;
        result.enabled = taskInfo.enabled;
        result.notification = taskInfo.notification;
        if (taskInfo.nextRunTime != null) {
            result.nextRunTime = taskInfo.nextRunTime.getTime();
        }
        ScheduledTaskExecutionInfo lastRun = null;
        if (taskInfo.prevRunTime != null) {
            lastRun = new ScheduledTaskExecutionInfo();
            lastRun.startTime = taskInfo.prevRunTime.getTime();
            lastRun.state = SchedulingUtil.toExecutionState((TaskInfo.State)taskInfo.state);
        }
        result.lastRunInfo = lastRun;
        result.scheduledTask = taskInfo.scheduledTask;
        result.lastModifiedUser = taskInfo.lastModifiedUser;
        result.lastModifiedTime = taskInfo.lastModifiedTime.getTime();
        result.recurrence = SchedulingUtil.toPlatformScheduler((TaskScheduler)taskInfo.scheduler);
        result.spec = new Object[]{taskInfo.action};
        result.object = new Object[]{taskInfo.taskObject};
        return result;
    }

    private ResultSet newEmptyResultSet() {
        return null;
    }

    private ResultSet processScheduledTaskQuery(ManagedObjectReference entity, PropertySpec[] propertySpecs) throws Exception {
        if (propertySpecs == null || propertySpecs.length == 0 || propertySpecs[0].propertyNames == null || propertySpecs[0].propertyNames.length == 0) {
            return this.newEmptyResultSet();
        }
        List<ResultItem> resultItems = null;
        String property = propertySpecs[0].propertyNames[0];
        if (property.equals("scheduledTaskInfo")) {
            resultItems = this.getScheduledOpeartionInfo(entity);
        } else if (property.equals("name")) {
            resultItems = this.getScheduledOperationName(entity);
        } else if (property.equals("scheduledTaskExecutionInfo")) {
            resultItems = this.getScheduledOperationExecutionInfo(entity);
        }
        if (resultItems != null) {
            ResultSet result = new ResultSet();
            result.totalMatchedObjectCount = resultItems.size();
            result.items = (ResultItem[])ArrayUtil.toArrayOrNull(resultItems, ResultItem.class);
            return result;
        }
        return this.newEmptyResultSet();
    }

    private ResultSet processRelationalQuery(QuerySpec query) throws Exception {
        RelationalConstraint constraint = (RelationalConstraint)query.resourceSpec.constraint;
        if (!"vsphere:ScheduledTask".equals(constraint.targetType)) {
            return this.newEmptyResultSet();
        }
        if (!"scheduledTask".equals(constraint.relation)) {
            return this.newEmptyResultSet();
        }
        if (!(constraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            return this.newEmptyResultSet();
        }
        ObjectIdentityConstraint source = (ObjectIdentityConstraint)constraint.constraintOnRelatedObject;
        if (!(source.target instanceof ManagedObjectReference)) {
            return this.newEmptyResultSet();
        }
        PropertySpec[] propertySpecs = query.resourceSpec.propertySpecs;
        if (propertySpecs == null || propertySpecs.length == 0 || propertySpecs[0].propertyNames == null || propertySpecs[0].propertyNames.length == 0) {
            return this.newEmptyResultSet();
        }
        String property = query.resourceSpec.propertySpecs[0].propertyNames[0];
        if (!property.equals("scheduledTaskInfo")) {
            return this.newEmptyResultSet();
        }
        ManagedObjectReference entity = (ManagedObjectReference)source.target;
        List<ManagedObjectReference> operations = this.getScheduledTasks(entity);
        if (operations.size() == 0) {
            return this.newEmptyResultSet();
        }
        List<ResultItem> resultItems = this.getScheduledOperationInfo(operations);
        ResultSet result = new ResultSet();
        result.totalMatchedObjectCount = resultItems.size();
        result.items = (ResultItem[])ArrayUtil.toArrayOrNull(resultItems, ResultItem.class);
        return result;
    }

    private List<ResultItem> getScheduledOperationInfo(List<ManagedObjectReference> scheduledOps) throws Exception {
        PropertyValue[] propValues;
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        Object[] tasks = (ManagedObjectReference[])ArrayUtil.toArray(scheduledOps, ManagedObjectReference.class);
        for (PropertyValue propValue : propValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])tasks, (String)"info")) {
            ManagedObjectReference task = (ManagedObjectReference)propValue.resourceObject;
            ScheduledTaskInfo taskInfo = (ScheduledTaskInfo)propValue.value;
            com.vmware.vise.core.model.scheduling.ScheduledTaskInfo opInfo = this.newPlatformScheduledTaskInfo(taskInfo);
            PropertyValue newValue = new PropertyValue();
            newValue.resourceObject = task;
            newValue.propertyName = "scheduledTaskInfo";
            newValue.value = opInfo;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = task;
            resultItem.properties = new PropertyValue[]{newValue};
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private List<ResultItem> getScheduledOpeartionInfo(ManagedObjectReference scheduledOp) throws Exception {
        ArrayList<ManagedObjectReference> param = new ArrayList<ManagedObjectReference>();
        param.add(scheduledOp);
        return this.getScheduledOperationInfo(param);
    }

    private List<ResultItem> getScheduledOperationName(List<ManagedObjectReference> scheduledOps) throws Exception {
        PropertyValue[] propValues;
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        Object[] tasks = (ManagedObjectReference[])ArrayUtil.toArray(scheduledOps, ManagedObjectReference.class);
        for (PropertyValue propValue : propValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])tasks, (String)"info.name")) {
            ManagedObjectReference task = (ManagedObjectReference)propValue.resourceObject;
            String taskName = (String)propValue.value;
            PropertyValue newValue = new PropertyValue();
            newValue.resourceObject = task;
            newValue.propertyName = "name";
            newValue.value = taskName;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = task;
            resultItem.properties = new PropertyValue[]{newValue};
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private List<ResultItem> getScheduledOperationName(ManagedObjectReference scheduledOp) throws Exception {
        ArrayList<ManagedObjectReference> param = new ArrayList<ManagedObjectReference>();
        param.add(scheduledOp);
        return this.getScheduledOperationName(param);
    }

    private List<ResultItem> getScheduledOperationExecutionInfo(List<ManagedObjectReference> scheduledOps) throws Exception {
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        ManagedObjectReference[] tasks = (ManagedObjectReference[])ArrayUtil.toArray(scheduledOps, ManagedObjectReference.class);
        if (tasks.length == 0) {
            return resultItems;
        }
        ManagedObjectReference moref = tasks[0];
        VcService vc = VimSessionUtil.getService((String)moref.getServerGuid());
        moref = vc.getServiceInstanceContent().getTaskManager();
        TaskManager taskManager = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moref);
        for (ManagedObjectReference scheduledTask : tasks) {
            TaskFilterSpec filterSpec = new TaskFilterSpec();
            filterSpec.scheduledTask = scheduledTask;
            moref = taskManager.createCollector(filterSpec);
            TaskHistoryCollector taskCollector = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moref);
            TaskInfo[] taskInfoData = taskCollector.getLatestPage();
            PropertyValue newValue = new PropertyValue();
            newValue.resourceObject = scheduledTask;
            newValue.propertyName = "scheduledTaskExecutionInfo";
            ArrayList<ScheduledTaskExecutionInfo> value = new ArrayList<ScheduledTaskExecutionInfo>();
            for (TaskInfo taskInfo : taskInfoData) {
                ScheduledTaskExecutionInfo execInfo = new ScheduledTaskExecutionInfo();
                execInfo.startTime = taskInfo.startTime != null ? taskInfo.startTime.getTime() : null;
                execInfo.endTime = taskInfo.completeTime != null ? taskInfo.completeTime.getTime() : null;
                execInfo.state = SchedulingUtil.toExecutionState((TaskInfo.State)taskInfo.state);
                OperationResult opResult = new OperationResult();
                opResult.result = this._taskSearchHelper.getClientTaskInfo(taskInfo);
                execInfo.result = new OperationResult[]{opResult};
                value.add(execInfo);
                if ((long)value.size() >= 5L) break;
            }
            newValue.value = ArrayUtil.toArray(value, ScheduledTaskExecutionInfo.class);
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = scheduledTask;
            resultItem.properties = new PropertyValue[]{newValue};
            resultItems.add(resultItem);
            taskCollector.remove();
        }
        return resultItems;
    }

    private List<ResultItem> getScheduledOperationExecutionInfo(ManagedObjectReference scheduledOp) throws Exception {
        ArrayList<ManagedObjectReference> param = new ArrayList<ManagedObjectReference>();
        param.add(scheduledOp);
        return this.getScheduledOperationExecutionInfo(param);
    }
}

