/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.ProtocolEndpoint;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ProtocolEndpointsDatastoresFilterBuilder
implements QueryFilterBuilder {
    private static final String HOST_KEY_PROPERTY = "hostKey";
    private static final String SUMMARY_TYPE_PROPERTY = "summary.type";
    private static final String INFO_VVOL_DS_PROPERTY = "info.vvolDS";
    private static final String VVOL_TYPE = "VVOL";
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;
    private static final ManagedObjectReference NON_EXISTING_DATASTORE = new ManagedObjectReference(Datastore.class.getSimpleName(), "noObjectId", "noServerGuid");

    public ProtocolEndpointsDatastoresFilterBuilder(ObjectReferenceService objectReferenceService, QueryServiceFactory queryServiceFactory) {
        this._objectReferenceService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @QueryFilter(value="protocolEndpointsDatastoresFilter")
    public Filter protocolEndpointsDatastoresFilter(String hostId, String[] protocolEndpointUuids) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{hostId});
        ManagedObjectReference hostRef = (ManagedObjectReference)this._objectReferenceService.getReference(hostId);
        ResultSet resultSet = this._queryService.select(new String[]{INFO_VVOL_DS_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(HOST_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef), new PropertyPredicate(SUMMARY_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)VVOL_TYPE)}).fetch();
        List datastoreItems = resultSet.getItems();
        HashSet<ManagedObjectReference> datastoreRefs = new HashSet<ManagedObjectReference>();
        if (datastoreItems != null && !datastoreItems.isEmpty()) {
            for (ResourceItem datastoreItem : datastoreItems) {
                VvolVolume.HostProtocolEndpoint[] hostProtocolEndpoints;
                VvolVolume vvolVolume = (VvolVolume)datastoreItem.get(INFO_VVOL_DS_PROPERTY);
                if (vvolVolume == null || (hostProtocolEndpoints = vvolVolume.getHostPE()) == null) continue;
                for (VvolVolume.HostProtocolEndpoint hostProtocolEndpoint : hostProtocolEndpoints) {
                    ProtocolEndpoint[] protocolEndpoints;
                    if (!hostRef.equals((Object)hostProtocolEndpoint.getKey()) || (protocolEndpoints = hostProtocolEndpoint.getProtocolEndpoint()) == null) continue;
                    for (ProtocolEndpoint protocolEndpoint : protocolEndpoints) {
                        if (!protocolEndpointUuids[0].equals(protocolEndpoint.getUuid())) continue;
                        datastoreRefs.add((ManagedObjectReference)datastoreItem.getKey());
                    }
                }
            }
        }
        if (datastoreRefs.isEmpty()) {
            datastoreRefs.add(NON_EXISTING_DATASTORE);
        }
        PropertyPredicate datastoresForProtocolEndpoint = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, datastoreRefs);
        return new Filter(Collections.singletonList(datastoresForProtocolEndpoint));
    }
}

