/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreOperationData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.h5.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DatastoreOperationsPropertyProvider
implements PropertyProviderBean {
    private static final String DS_HOST_MOUNT_PROP = "hostMount";
    private static final String DS_MOUNTED_HOST_REFS_PROP = "hostKey";
    private static final String DS_INFO_PROP = "info";
    private static final String NAME_PROPERTY = "name";
    private static final String DATACENTER_PROP = "dc";
    private static final String HOST_POWER_STATE_PROPERTY = "runtime/powerState";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime/connectionState";
    private static final String HOST_CLUSTER_NAME_PROPERTY = "hostClusterName";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String[] HOST_CONFIG_STORAGE_PRIV = new String[]{"Host.Config.Storage"};
    public static final String HOST_CAPABILITY_NFS3_SUPPORTED_PROP = "capability/nfsSupported";
    public static final String HOST_CAPABILITY_NFS41_SUPPORTED_PROP = "capability/nfs41Supported";
    public static final String HOST_IN_DOMAIN_PROPERTY = "inDomain";
    public static final String HOST_NFS_KERBEROS_USER_PROP = "nfsKerberosUser";
    public static final String HOST_CAPABILITY_NFS41_KRB5I_SUPPORTED_PROP = "capability/nfs41Krb5iSupported";
    private final QueryService _queryService;

    public DatastoreOperationsPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountVmfs")
    public DatastoreOperationData getAvailableHostsForMountVmfs(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo mountInfo) {
                return Boolean.FALSE.equals(mountInfo.mounted);
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForUnmount")
    public DatastoreOperationData getAvailableHostsForUnmount(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo mountInfo) {
                return Boolean.TRUE.equals(mountInfo.mounted);
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForUnmountNfs")
    public DatastoreOperationData getAvailableHostsForUnmountNfs(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo hostMount) {
                return true;
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountNfs")
    public DatastoreOperationData getAvailableHostsForMountNfs(ManagedObjectReference dsRef) throws Exception {
        return this.getAvailableHostsForMount(dsRef, true);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountVvol")
    public DatastoreOperationData getAvailableHostsForMountVvol(ManagedObjectReference dsRef) throws Exception {
        return this.getAvailableHostsForMount(dsRef, false);
    }

    private DatastoreOperationData getAvailableHostsForMount(ManagedObjectReference dsRef, boolean isNfs) throws Exception {
        QueryCommand queryCommand;
        Map dsProperties = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String[])new String[]{DATACENTER_PROP, DS_MOUNTED_HOST_REFS_PROP, DS_INFO_PROP});
        HostValidator hostValidator = isNfs ? new NfsHostMountValidator((NasDatastoreInfo)dsProperties.get(DS_INFO_PROP)) : new HostValidator();
        ManagedObjectReference dcMor = (ManagedObjectReference)dsProperties.get(DATACENTER_PROP);
        Object[] mountedHostRefs = (Object[])dsProperties.get(DS_MOUNTED_HOST_REFS_PROP);
        if (mountedHostRefs == null) {
            mountedHostRefs = new ManagedObjectReference[]{};
        }
        if (dcMor == null) {
            return DatastoreOperationData.emptyData();
        }
        PropertyPredicate dcPredicate = new PropertyPredicate(DATACENTER_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dcMor);
        QueryCommand.Builder queryBuilder = this._queryService.select(hostValidator.getHostPropertiesToRetrieve()).from(new String[]{HostSystem.class.getSimpleName()});
        if (mountedHostRefs.length != 0) {
            PropertyPredicate hostNotMountedPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, Arrays.asList(mountedHostRefs));
            queryCommand = queryBuilder.where(LogicalOperator.AND, new PropertyPredicate[]{dcPredicate, hostNotMountedPredicate}).build();
        } else {
            queryCommand = queryBuilder.where(new PropertyPredicate[]{dcPredicate}).build();
        }
        return this.buildDatastoreOperationData(queryCommand, hostValidator);
    }

    private DatastoreOperationData getAvailableHostsForVmfsMountUnmountOperation(ManagedObjectReference dsRef, HostMountPredicate hostMountPredicate) {
        Datastore.HostMount[] dsHostMount = (Datastore.HostMount[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String)DS_HOST_MOUNT_PROP);
        if (dsHostMount == null) {
            return DatastoreOperationData.emptyData();
        }
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        for (Datastore.HostMount hostMount : dsHostMount) {
            if (!hostMountPredicate.test(hostMount.mountInfo)) continue;
            hostRefs.add(hostMount.key);
        }
        if (hostRefs.isEmpty()) {
            return DatastoreOperationData.emptyData();
        }
        HostValidator hostValidator = new HostValidator();
        QueryCommand queryCommand = this._queryService.select(hostValidator.getHostPropertiesToRetrieve()).from(new String[]{HostSystem.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, hostRefs).build();
        return this.buildDatastoreOperationData(queryCommand, hostValidator);
    }

    private DatastoreOperationData buildDatastoreOperationData(QueryCommand queryCommand, HostValidator hostValidator) {
        DatastoreOperationData result = new DatastoreOperationData();
        ArrayList<DatastoreOperationData.HostData> availableHosts = new ArrayList<DatastoreOperationData.HostData>();
        ResultSet resultSet = queryCommand.fetch();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            DatastoreOperationData.HostData hostData = new DatastoreOperationData.HostData();
            hostData.hostRef = (ManagedObjectReference)resourceItem.getKey();
            hostData.clusterName = (String)resourceItem.get(HOST_CLUSTER_NAME_PROPERTY);
            HostValidator.ValidationResult hostValidationResult = hostValidator.validate(resourceItem);
            hostData.formattedName = hostValidationResult.formattedHostName;
            hostData.isOperationAllowed = hostValidationResult.isOperationAllowed;
            availableHosts.add(hostData);
        }
        result.availableHosts = availableHosts.toArray(new DatastoreOperationData.HostData[availableHosts.size()]);
        return result;
    }

    private static class HostValidator {
        private static final List<String> propertiesToRetrieve = Collections.unmodifiableList(Arrays.asList("name", "runtime/connectionState", "runtime/powerState", "grantedPrivileges", "hostClusterName"));

        private HostValidator() {
        }

        public List<String> getHostPropertiesToRetrieve() {
            return propertiesToRetrieve;
        }

        public ValidationResult validate(ResourceItem hostProperties) {
            String hostName = (String)hostProperties.get(DatastoreOperationsPropertyProvider.NAME_PROPERTY);
            if (HostValidator.isHostConnected(hostProperties)) {
                if (HostValidator.hasConfigStoragePrivilege(hostProperties)) {
                    return new ValidationResult(true, hostName);
                }
                return new ValidationResult(false, StorageStringUtil.getString("hostName.notEnoughPrivileges", hostName));
            }
            return new ValidationResult(false, StorageUtil.formatHostName(hostName, (HostSystem.ConnectionState)hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CONNECTION_STATE_PROPERTY), (HostSystem.PowerState)hostProperties.get(DatastoreOperationsPropertyProvider.HOST_POWER_STATE_PROPERTY)));
        }

        protected static boolean isHostConnected(ResourceItem hostProperties) {
            return HostSystem.ConnectionState.connected.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CONNECTION_STATE_PROPERTY));
        }

        protected static boolean hasConfigStoragePrivilege(ResourceItem hostProperties) {
            return AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIV, (String[])((String[])hostProperties.get(DatastoreOperationsPropertyProvider.GRANTED_PRIVILEGES_PROP)));
        }

        public static final class ValidationResult {
            private String formattedHostName;
            private boolean isOperationAllowed;

            public ValidationResult(Boolean isOperationAllowed, String formattedHostName) {
                this.isOperationAllowed = isOperationAllowed != null && isOperationAllowed != false;
                this.formattedHostName = formattedHostName;
            }
        }
    }

    private static class NfsHostMountValidator
    extends HostValidator {
        private final NasDatastoreInfo dsInfo;
        private static final List<String> propertiesToRetrieve = Collections.unmodifiableList(Arrays.asList("name", "runtime/connectionState", "runtime/powerState", "grantedPrivileges", "hostClusterName", "nfsKerberosUser", "inDomain", "capability/nfs41Krb5iSupported", "capability/nfsSupported", "capability/nfs41Supported"));

        private NfsHostMountValidator(NasDatastoreInfo dsInfo) {
            this.dsInfo = dsInfo;
        }

        @Override
        public List<String> getHostPropertiesToRetrieve() {
            return propertiesToRetrieve;
        }

        @Override
        public HostValidator.ValidationResult validate(ResourceItem hostProperties) {
            HostValidator.ValidationResult superValidationResult = super.validate(hostProperties);
            if (!superValidationResult.isOperationAllowed) {
                return superValidationResult;
            }
            String hostName = (String)hostProperties.get(DatastoreOperationsPropertyProvider.NAME_PROPERTY);
            if ("NFS".equals(this.dsInfo.nas.type)) {
                return new HostValidator.ValidationResult((Boolean)hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS3_SUPPORTED_PROP), hostName);
            }
            if ("NFS41".equals(this.dsInfo.nas.type)) {
                boolean isKerberosEnabledOnDatastore;
                Boolean isNfs41Supported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS41_SUPPORTED_PROP));
                if (!isNfs41Supported.booleanValue()) {
                    return new HostValidator.ValidationResult(false, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.nfsv41NotSupported", hostName));
                }
                boolean bl = isKerberosEnabledOnDatastore = NasVolume.SecurityType.SEC_KRB5.toString().equals(this.dsInfo.getNas().getSecurityType()) || NasVolume.SecurityType.SEC_KRB5I.toString().equals(this.dsInfo.getNas().getSecurityType());
                if (isKerberosEnabledOnDatastore) {
                    Boolean isInDomain = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_IN_DOMAIN_PROPERTY));
                    if (!isInDomain.booleanValue()) {
                        return new HostValidator.ValidationResult(false, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.hostNotInDomain", hostName));
                    }
                    Object hostNfsKrbUsr = hostProperties.get(DatastoreOperationsPropertyProvider.HOST_NFS_KERBEROS_USER_PROP);
                    if (hostNfsKrbUsr == null || hostNfsKrbUsr instanceof String && ((String)hostNfsKrbUsr).isEmpty()) {
                        return new HostValidator.ValidationResult(false, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.noCredentials", hostName));
                    }
                    Boolean isKrbi5Supported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS41_KRB5I_SUPPORTED_PROP));
                    if (NasVolume.SecurityType.SEC_KRB5I.toString().equals(this.dsInfo.getNas().getSecurityType()) && !isKrbi5Supported.booleanValue()) {
                        return new HostValidator.ValidationResult(false, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.krb5iNotSupported", hostName));
                    }
                }
            }
            return superValidationResult;
        }
    }

    private static interface HostMountPredicate {
        public boolean test(MountInfo var1);
    }
}

