/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DatastoreMoveToPropertyProvider {
    private static final String DC_PROPERTY = "dc";
    private static final String TYPE_PROPERTY = "summary.type";
    private final QueryService queryService;

    public DatastoreMoveToPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Datastore/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailable(Collection<ManagedObjectReference> datastoreRefs) {
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, datastoreRefs));
        ResultSet resultSet = this.queryService.select(new String[]{"@modelKey", DC_PROPERTY, TYPE_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, filter).fetch();
        boolean areDatastoresHomogenous = this.areDatastoresHomogenous(resultSet.getItems());
        return new ArrayList<Boolean>(Collections.nCopies(datastoreRefs.size(), areDatastoresHomogenous));
    }

    private boolean areDatastoresHomogenous(List<ResourceItem> resourceItems) {
        if (!CollectionUtil.isNullOrEmpty(resourceItems)) {
            ManagedObjectReference firstElementDatacenter = (ManagedObjectReference)resourceItems.get(0).get(DC_PROPERTY);
            String firstElementType = (String)resourceItems.get(0).get(TYPE_PROPERTY);
            if (firstElementDatacenter == null || firstElementType == null) {
                return false;
            }
            for (int i = 1; i < resourceItems.size(); ++i) {
                ResourceItem current = resourceItems.get(i);
                boolean isDatacenterSame = firstElementDatacenter.equals(current.get(DC_PROPERTY));
                boolean isTypeSame = firstElementType.equals(current.get(TYPE_PROPERTY));
                if (isDatacenterSame && isTypeSame) continue;
                return false;
            }
        }
        return true;
    }
}

