/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.cluster;

import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.List;

public class HeartbeatRequirement {
    private static final int DEFAULT_HEARTBEAT_DATASTORE_THRESHOLD = 2;
    private static final String DAS_HEARTBEAT_DS_PER_HOST = "das.heartbeatDsPerHost";
    public ManagedObjectReference clusterRef;
    public List<ManagedObjectReference> heartbeatDatastores;
    public DasConfigInfo dasConfigInfo;
    public String clusterName;

    public HeartbeatRequirement(ManagedObjectReference clusterRef, List<ManagedObjectReference> heartbeatDatastores, DasConfigInfo dasConfigInfo, String clusterName) {
        this.clusterRef = clusterRef;
        this.heartbeatDatastores = heartbeatDatastores;
        this.dasConfigInfo = dasConfigInfo;
        this.clusterName = clusterName;
    }

    public boolean isHeartbeatAffected(ManagedObjectReference dsRef) {
        if (this.heartbeatDatastores.contains(dsRef)) {
            Integer heartbeatDatastoreThreshold = 2;
            String thresholdOption = (String)HeartbeatRequirement.getOption(this.dasConfigInfo.getOption(), DAS_HEARTBEAT_DS_PER_HOST);
            if (thresholdOption != null) {
                heartbeatDatastoreThreshold = Integer.parseInt(thresholdOption);
            }
            return this.heartbeatDatastores.size() - 1 < heartbeatDatastoreThreshold;
        }
        return false;
    }

    private static <T> T getOption(OptionValue[] optionValues, String key) {
        if (optionValues == null) {
            return null;
        }
        for (OptionValue optionValue : optionValues) {
            if (!key.equals(optionValue.getKey())) continue;
            return (T)optionValue.getValue();
        }
        return null;
    }
}

