/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.TokenPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.TokenPolicySpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenPolicyServiceImpl
extends AdminServiceBase
implements TokenPolicyService {
    private static final Log _logger = LogFactory.getLog(TokenPolicyServiceImpl.class);

    public TokenPolicyServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, transformer);
    }

    @Override
    public TokenPolicySpec getTokenPolicy() throws Exception {
        ConfigurationManagementService configService = this.getConfigService();
        TokenPolicySpec currentPolicy = new TokenPolicySpec();
        try {
            currentPolicy.clockTolerance = configService.getClockTolerance();
            currentPolicy.maxTokenRenewalCount = configService.getRenewCount();
            currentPolicy.maxTokenDelegationCount = configService.getDelegationCount();
            currentPolicy.maxBearerTokenLifetime = configService.getMaximumBearerTokenLifetime();
            currentPolicy.maxHoKTokenLifetime = configService.getMaximumHoKTokenLifetime();
        }
        catch (Exception e) {
            _logger.error((Object)"Unable to get token policy", (Throwable)e);
            throw this.transformBackendException(e);
        }
        return currentPolicy;
    }

    @Override
    public void updateTokenPolicy(TokenPolicySpec newPolicy) throws IllegalArgumentException, Exception {
        ConfigurationManagementService configService = this.getConfigService();
        try {
            this.validateTokenPolicy(newPolicy);
            configService.setClockTolerance(newPolicy.clockTolerance);
            configService.setRenewCount(newPolicy.maxTokenRenewalCount);
            configService.setDelegationCount(newPolicy.maxTokenDelegationCount);
            configService.setMaximumBearerTokenLifetime(newPolicy.maxBearerTokenLifetime);
            configService.setMaximumHoKTokenLifetime(newPolicy.maxHoKTokenLifetime);
        }
        catch (Exception e) {
            _logger.error((Object)"Unable to get token policy", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    private final void validateTokenPolicy(TokenPolicySpec newPolicy) throws IllegalArgumentException {
        String illegalPolicyValue = null;
        if (newPolicy.maxTokenRenewalCount <= 0) {
            illegalPolicyValue = Integer.toString(newPolicy.maxTokenRenewalCount);
        } else if (newPolicy.maxTokenDelegationCount <= 0) {
            illegalPolicyValue = Integer.toString(newPolicy.maxTokenDelegationCount);
        } else if (newPolicy.maxBearerTokenLifetime <= 0L) {
            illegalPolicyValue = Long.toString(newPolicy.maxBearerTokenLifetime);
        } else if (newPolicy.maxHoKTokenLifetime <= 0L) {
            illegalPolicyValue = Long.toString(newPolicy.maxHoKTokenLifetime);
        }
        if (illegalPolicyValue != null) {
            throw new IllegalArgumentException("Illegal non-positive value: " + illegalPolicyValue);
        }
    }

    private final ConfigurationManagementService getConfigService() throws SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        ConfigurationManagementService configService = this.getAdminService(session).getConfigurationManagementService();
        return configService;
    }
}

