/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.SystemManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemManagementServiceImpl
extends AdminServiceBase
implements SystemManagementService {
    private static final Log _logger = LogFactory.getLog(SystemManagementServiceImpl.class);

    public SystemManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, transformer);
    }

    @Override
    public String getDomainName() throws SsoServiceException {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            SsoAdminService adminService = this.getAdminService(session);
            ActiveDirectoryJoinInfo activeDirectoryJoinInfo = adminService.getSystemManagementService().getActiveDirectoryJoinStatus();
            if (!activeDirectoryJoinInfo.getJoinStatus().equals(ActiveDirectoryJoinInfo.JoinStatus.ACTIVE_DIRECTORY_JOIN_STATUS_DOMAIN.toString())) {
                return "";
            }
            return activeDirectoryJoinInfo.getName();
        }
        catch (SsoServiceException e) {
            _logger.warn((Object)("Error while extracting domain name information : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void joinActiveDirectory(String adDomain, String ouUnit, String userName, String passWord) throws Exception {
        try {
            this.getAdminService().getSystemManagementService().joinActiveDirectory(userName, passWord, adDomain, ouUnit);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error while joining the Active Directory Domain : " + ex.getMessage()), (Throwable)ex);
            throw this.transformBackendException(ex);
        }
    }

    @Override
    public void leaveActiveDirectory(String userName, String passWord) throws Exception {
        try {
            this.getAdminService().getSystemManagementService().leaveActiveDirectory(userName, passWord);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error while leaving the Active Directory Domain : " + ex.getMessage()), (Throwable)ex);
            throw this.transformBackendException(ex);
        }
    }

    @Override
    public ActiveDirectoryJoinInfo getActiveDirectoryInfo() throws Exception {
        try {
            return this.getAdminService().getSystemManagementService().getActiveDirectoryJoinStatus();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error while fetching Active Directory join status : " + ex.getMessage()), (Throwable)ex);
            throw this.transformBackendException(ex);
        }
    }

    private SsoAdminService getAdminService() throws SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        return this.getAdminService(session);
    }
}

