/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.GroupDetails;
import com.vmware.vim.binding.sso.admin.PersonDetails;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.PrincipalManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.ApplicationUser;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrincipalManagementServiceImpl
extends AdminServiceBase
implements PrincipalManagementService {
    private static final Log _logger = LogFactory.getLog(PrincipalManagementServiceImpl.class);
    private static final int USER_COUNT_LIMIT = 200;
    private String _systemDomainName;

    public PrincipalManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, transformer);
    }

    public PrincipalManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, Boolean useSolutionUser, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, useSolutionUser, transformer);
    }

    public PrincipalManagementServiceImpl(SsoAdminService presetAdminService) {
        super(presetAdminService);
    }

    private synchronized String getSystemDomainName() throws SsoServiceException {
        if (StringUtil.isNullOrEmpty((String)this._systemDomainName)) {
            HttpSession session = SessionUtil.getHttpSession();
            this._systemDomainName = this.getAdminService(session).getIdentitySourceManagementService().getSystemDomainName();
        }
        return this._systemDomainName;
    }

    @Override
    public void addToGroup(PrincipalId[] userIds, PrincipalId[] groupIds, String groupname) throws Exception {
        boolean[] groupsAdded = new boolean[]{};
        boolean[] usersAdded = new boolean[]{};
        boolean errorsExist = false;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            if (!ArrayUtil.isNullOrEmpty((Object[])userIds)) {
                usersAdded = this.getAdminService(session).getPrincipalManagementService().addUsersToLocalGroup(userIds, groupname);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])groupIds)) {
                groupsAdded = this.getAdminService(session).getPrincipalManagementService().addGroupsToLocalGroup(groupIds, groupname);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.addToGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
        for (boolean groupAdded : groupsAdded) {
            errorsExist |= !groupAdded;
        }
        for (boolean userAdded : usersAdded) {
            errorsExist |= !userAdded;
        }
        if (errorsExist) {
            throw new InvalidArgument();
        }
    }

    @Override
    public void createGroup(String groupname, GroupDetails details) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().createLocalGroup(groupname, details);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.createGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void updateGroup(String groupname, GroupDetails details) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().updateLocalGroupDetails(groupname, details);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.updateGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public PersonUser findUserAccount(String username) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchResult searchResult = this.getAdminService(session).getPrincipalDiscoveryService().findUserAccount(username);
            if (searchResult.personUsers != null && searchResult.personUsers.length > 0) {
                return searchResult.personUsers[0];
            }
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUserAccount", (Throwable)e);
            throw this.transformBackendException(e);
        }
        return null;
    }

    @Override
    public void createUser(String username, PersonDetails details, String password) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().createLocalPersonUser(username, details, password);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.createUser", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void deletePrincipal(PrincipalId principalId) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().deleteLocalPrincipal(principalId.name);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.deletePrincipal", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void editUser(String domain, String username, PersonDetails details, String password) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            if (details != null) {
                this.getAdminService(session).getPrincipalManagementService().updateLocalPersonUserDetails(username, details);
            }
            if (!StringUtil.isNullOrEmpty((String)password)) {
                this.getAdminService(session).getPrincipalManagementService().resetLocalPersonUserPassword(username, password);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.editUser", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void editUserOwnDetails(PersonDetails details, String password, String username, String oldPassword) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().updateSelfLocalPersonUserDetails(details);
            if (!StringUtil.isNullOrEmpty((String)password) && !StringUtil.isNullOrEmpty((String)oldPassword)) {
                this.getAdminService(session).getPrincipalManagementService().resetLocalUserPassword(username, oldPassword, password);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.editSelfUser", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public Group[] findGroups(String domain, String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchCriteria search = new PrincipalDiscoveryService.SearchCriteria();
            search.domain = StringUtil.isNullOrEmpty((String)domain) ? this.getSystemDomainName() : domain;
            search.searchString = criteria;
            return this.getAdminService(session).getPrincipalDiscoveryService().findGroups(search, 200);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroups", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public Group findGroupAccount(String groupName) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getPrincipalDiscoveryService().findGroupAccount(groupName);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroupAccount", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public Group[] findGroupsInGroup(PrincipalId principalId, String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getPrincipalDiscoveryService().findGroupsInGroup(principalId, criteria, 200);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroupsInGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public ApplicationUser[] findSolutionUsers(String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            Object[] users = this.getAdminService(session).getPrincipalDiscoveryService().findSolutionUsers(criteria, 200);
            if (ArrayUtil.isNullOrEmpty((Object[])users)) {
                return new ApplicationUser[0];
            }
            ArrayList<ApplicationUser> result = new ArrayList<ApplicationUser>(users.length);
            for (Object user : users) {
                result.add(SsoAdminUtil.toApplicationUser((SolutionUser)user));
            }
            return (ApplicationUser[])ArrayUtil.toArray(result, ApplicationUser.class);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findSolutionUsers", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public PrincipalDiscoveryService.SearchResult find(String domain, String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchCriteria search = new PrincipalDiscoveryService.SearchCriteria();
            search.domain = StringUtil.isNullOrEmpty((String)domain) ? this.getSystemDomainName() : domain;
            search.searchString = criteria;
            return this.getAdminService(session).getPrincipalDiscoveryService().findByName(search, 200);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.find", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public PersonUser[] findUsers(String domain, String criteria) throws Exception {
        try {
            PrincipalDiscoveryService.SearchCriteria search = new PrincipalDiscoveryService.SearchCriteria();
            search.domain = domain;
            search.searchString = criteria;
            PersonUser[] result = this.findPersonUsersInternal(search);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUsers", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    private PersonUser[] findPersonUsersInternal(PrincipalDiscoveryService.SearchCriteria criteria) throws NotAuthenticated, InvalidCredentials, SsoServiceException, InvalidPrincipalFault {
        PersonUser[] result;
        block4: {
            HttpSession session = SessionUtil.getHttpSession();
            PrincipalDiscoveryService discovery = this.getAdminService(session).getPrincipalDiscoveryService();
            result = new PersonUser[]{};
            if (StringUtil.isNullOrEmpty((String)criteria.domain)) {
                PersonUser user = discovery.findSelfPersonUser();
                if (this.isMatching(user, criteria)) {
                    result = new PersonUser[]{user};
                }
                return result;
            }
            try {
                result = this.getAdminService(session).getPrincipalDiscoveryService().findPersonUsers(criteria, 200);
            }
            catch (NoPermission e) {
                PersonUser user = discovery.findSelfPersonUser();
                if (!this.isMatching(user, criteria)) break block4;
                result = new PersonUser[]{user};
            }
        }
        return result;
    }

    private boolean isMatching(PersonUser user, PrincipalDiscoveryService.SearchCriteria criteria) {
        String value;
        if (!StringUtil.isNullOrEmpty((String)criteria.domain) && !criteria.domain.equalsIgnoreCase(user.id.domain)) {
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)criteria.searchString)) {
            return true;
        }
        String searchString = criteria.searchString.toLowerCase();
        if (!StringUtil.isNullOrEmpty((String)user.id.name) && (value = user.id.name.toLowerCase()).indexOf(searchString) > -1) {
            return true;
        }
        if (!StringUtil.isNullOrEmpty((String)user.details.firstName) && (value = user.details.firstName.toLowerCase()).indexOf(searchString) > -1) {
            return true;
        }
        if (!StringUtil.isNullOrEmpty((String)user.details.lastName) && (value = user.details.lastName.toLowerCase()).indexOf(searchString) > -1) {
            return true;
        }
        return user.alias != null && !StringUtil.isNullOrEmpty((String)user.alias.name) && (value = user.alias.name.toLowerCase()).indexOf(searchString) > -1;
    }

    @Override
    public PersonUser[] findDisabledUsers(String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            PersonUser[] foundUsers = this.getAdminService(session).getPrincipalDiscoveryService().findDisabledPersonUsers(criteria, 200);
            return foundUsers;
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findDisabledUsers", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public PersonUser[] findLockedUsers(String criteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            PersonUser[] foundUsers = this.getAdminService(session).getPrincipalDiscoveryService().findLockedUsers(criteria, 200);
            return foundUsers;
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findLockedUsers", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public PersonUser[] findUsersInGroup(PrincipalId groupId, String searchCriteria) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getPrincipalDiscoveryService().findPersonUsersInGroup(groupId, searchCriteria, 200);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUsersInGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void removeFromGroup(PrincipalId[] principalIds, String groupname) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().removePrincipalsFromLocalGroup(principalIds, groupname);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.removeFromGroup", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public void setUserPassword(String username, String password) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getPrincipalManagementService().resetLocalPersonUserPassword(username, password);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.setUserPassword", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public boolean enableUser(PrincipalId principalId, boolean enable) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            boolean result = enable ? this.getAdminService(session).getPrincipalManagementService().enableUserAccount(principalId) : this.getAdminService(session).getPrincipalManagementService().disableUserAccount(principalId);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.enableUser", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public boolean unlockUser(PrincipalId principalId) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            return this.getAdminService(session).getPrincipalManagementService().unlockUserAccount(principalId);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.unlockUser", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public boolean changePasswordAllowed() throws Exception {
        HttpSession session = SessionUtil.getHttpSession();
        SamlToken token = AuthSessionUtil.getSsoToken((HttpSession)session);
        String loggedUserDomainName = token.getSubject().getDomain();
        String systemDomainName = this.getSystemDomainName();
        return loggedUserDomainName.equalsIgnoreCase(systemDomainName);
    }

    @Override
    public void changePassword(String currentPassword, String newPassword) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            SamlToken token = AuthSessionUtil.getSsoToken((HttpSession)session);
            String userName = token.getSubject().getName();
            this.getAdminService(session).getPrincipalManagementService().resetLocalUserPassword(userName, currentPassword, newPassword);
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.changePassword", (Throwable)e);
            throw this.transformBackendException(e);
        }
    }

    @Override
    public int getSelfPasswordExpiration() throws Exception {
        int result = -1;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            result = this.getAdminService(session).getPrincipalManagementService().getDaysRemainingUntilSelfPasswordExpiration();
        }
        catch (Exception e) {
            _logger.error((Object)"PrincipalManagementServiceImpl.getSelfPasswordExpiration", (Throwable)e);
            throw this.transformBackendException(e);
        }
        return result;
    }
}

