/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PemKeyStoreSpi
extends KeyStoreSpi {
    private static final Log _logger = LogFactory.getLog(PemKeyStoreSpi.class);
    private static final String BEGIN_CERT_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT_MARKER = "-----END CERTIFICATE-----";
    private static final String BEGIN_ENCR_PK_MARKER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static final String END_ENCR_PK_MARKER = "-----END ENCRYPTED PRIVATE KEY-----";
    private static final String BEGIN_PK_MARKER = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PK_MARKER = "-----END PRIVATE KEY-----";
    private static final String BEGIN_RSA_PK_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String END_RSA_PK_MARKER = "-----END RSA PRIVATE KEY-----";
    private static final String UTF_8 = "UTF-8";
    private static final String RSA_KEY = "RSA";
    private static final String DEFAULT_CHAIN_ALIAS = "Chain";
    private Vector<String> _aliases = new Vector();
    private List<Section> _sections = new ArrayList<Section>();

    @Override
    public Enumeration<String> engineAliases() {
        return this._aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this._aliases.size() == 1 && this._aliases.firstElement().equals(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new ProviderException("engineDeleteEntry not supported");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        throw new ProviderException("engineGetCertificate not supported");
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        throw new ProviderException("engineGetCertificateAlias not supported");
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (this._aliases.size() != 1 || !this._aliases.firstElement().equals(alias)) {
            return null;
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (Section section : this._sections) {
            if (!section.type.equals(END_CERT_MARKER)) continue;
            result.add(section.certificate);
        }
        return (Certificate[])ArrayUtil.toArrayOrNull(result, Certificate.class);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new ProviderException("engineGetCreationDate not supported");
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key result = null;
        for (Section section : this._sections) {
            if (section.type.equals(END_ENCR_PK_MARKER)) {
                result = this.engineGetKeyEncrypted(section, password);
                break;
            }
            if (!section.type.equals(END_RSA_PK_MARKER) && !section.type.equals(END_PK_MARKER)) continue;
            result = this.engineGetKeyUnencrypted(section);
            break;
        }
        return result;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isKeyEntiry = this.engineIsKeyEntry(alias);
        return !isKeyEntiry;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (this._aliases.size() != 1 || !this._aliases.firstElement().equals(alias)) {
            return false;
        }
        for (Section section : this._sections) {
            if (!section.type.equals(END_ENCR_PK_MARKER) && !section.type.equals(END_RSA_PK_MARKER) && !section.type.equals(END_PK_MARKER)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        boolean inSection = false;
        StringBuffer sectionData = null;
        while (br.ready()) {
            String line = br.readLine();
            if (line.startsWith(BEGIN_CERT_MARKER) || line.startsWith(BEGIN_ENCR_PK_MARKER) || line.startsWith(BEGIN_PK_MARKER) || line.startsWith(BEGIN_RSA_PK_MARKER)) {
                inSection = true;
                sectionData = new StringBuffer();
                continue;
            }
            if (line.startsWith(END_CERT_MARKER) || line.startsWith(END_ENCR_PK_MARKER) || line.startsWith(END_PK_MARKER) || line.startsWith(END_RSA_PK_MARKER)) {
                inSection = false;
                Section section = this.createNewSection(line, sectionData.toString());
                this._sections.add(section);
                continue;
            }
            if (!inSection) continue;
            sectionData.append(line);
        }
        if (this._sections.size() > 0) {
            this._aliases.add(DEFAULT_CHAIN_ALIAS);
        }
    }

    private Section createNewSection(String type2, String data2) throws UnsupportedEncodingException {
        Section section = new Section();
        section.type = type2;
        section.data = data2;
        section.derData = Base64.decodeBase64((byte[])section.data.getBytes(UTF_8));
        if (section.type.equals(END_CERT_MARKER)) {
            section.certificate = CertificateUtil.decodeCertificate((byte[])section.derData);
        }
        return section;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new ProviderException("engineSetCertificateEntry not supported");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    @Override
    public int engineSize() {
        return this._sections.size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    private Key engineGetKeyUnencrypted(Section pemSection) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pemSection.derData);
            KeyFactory kf = KeyFactory.getInstance(RSA_KEY);
            PrivateKey result = kf.generatePrivate(spec);
            return result;
        }
        catch (InvalidKeySpecException e) {
            _logger.warn((Object)("Failed to construct the private key:" + e.getMessage()));
            throw new NoSuchAlgorithmException(e.getLocalizedMessage(), e);
        }
    }

    private Key engineGetKeyEncrypted(Section pemSection, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (password == null || password == null) {
            throw new UnrecoverableKeyException(SsoAdminUtil.getString("sso.admin.exception.noPassword", new String[0]));
        }
        try {
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(pemSection.derData);
            SecretKeyFactory skFac = SecretKeyFactory.getInstance(epki.getAlgName());
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
            SecretKey pbeKey = skFac.generateSecret(pbeKeySpec);
            PKCS8EncodedKeySpec pkcs8KeySpec = epki.getKeySpec(pbeKey);
            KeyFactory kf = KeyFactory.getInstance(RSA_KEY);
            PrivateKey result = kf.generatePrivate(pkcs8KeySpec);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            _logger.error((Object)("NoSuchAlgorithmException:" + e.getLocalizedMessage()));
            String message = SsoAdminUtil.getString("sso.admin.exception.noAlgorithm", e.getLocalizedMessage());
            throw new NoSuchAlgorithmException(message, e);
        }
        catch (IOException e) {
            _logger.error((Object)("IOException:" + e.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(e.getLocalizedMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            _logger.error((Object)("InvalidKeySpecException:" + e.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(e.getLocalizedMessage(), e);
        }
        catch (InvalidKeyException e) {
            _logger.error((Object)("InvalidKeyException:" + e.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(e.getLocalizedMessage(), e);
        }
    }

    private static class Section {
        String type;
        String data;
        byte[] derData;
        X509Certificate certificate;

        private Section() {
        }
    }
}

