/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.sso.admin.SsoException;
import com.vmware.vsphere.client.sso.admin.impl.IdentityProviderServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.ExportIdentityProviderSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentityProviderPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(IdentityProviderPropertyProvider.class);
    private final IdentityProviderServiceImpl _identityProviderService;

    public IdentityProviderPropertyProvider(SsoService ssoService, IdentityProviderServiceImpl idpService) {
        _logger.debug((Object)"instantiated");
        this._identityProviderService = idpService;
    }

    @ModelMetadata(type={"sso:IdentityProvider"}, property="vsphere:providerConfiguration")
    public ExportIdentityProviderSpec getProviderConfiguration(Object object, ExportIdentityProviderSpec spec) throws SsoException {
        try {
            return this._identityProviderService.exportIdentityProviderConfiguration(spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error while extracting local SSO users", (Throwable)e);
            throw new SsoException("Error while extracting local SSO users", e);
        }
    }
}

