/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.SystemManagementService;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainManagerPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DomainManagerPropertyProvider.class);
    private final IdentitySourceDomainManagementService _domainManagementService;
    private final SystemManagementService _systemManagementService;

    public DomainManagerPropertyProvider(SsoService ssoService, IdentitySourceDomainManagementService domainManagementService, SystemManagementService systemManagementService) {
        _logger.debug((Object)"instantiated");
        this._domainManagementService = domainManagementService;
        this._systemManagementService = systemManagementService;
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="idsCertificates")
    public X509Spec[] getIdsCertificates(URI domainManager) throws InvalidCredentials, SsoServiceException, UnsupportedEncodingException {
        Object[] certificates = this._domainManagementService.getExternalDomainsCertificates();
        ArrayList<X509Spec> result = new ArrayList<X509Spec>();
        for (String certificate : (String[])ArrayUtil.toSafe((Object[])certificates, String.class)) {
            X509Certificate c = CertificateUtil.decodeCertificate((String)certificate);
            X509Spec x509 = new X509Spec(c);
            result.add(x509);
        }
        return (X509Spec[])ArrayUtil.toArray(result, X509Spec.class);
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:identitySourceList")
    public DomainSpec[] getIdentitySources(Object object, boolean populateDefaultDomains) throws Exception {
        List<DomainSpec> domains = this._domainManagementService.getIdentitySources(populateDefaultDomains);
        _logger.debug((Object)("Found " + domains.size() + " identity sources"));
        return (DomainSpec[])ArrayUtil.toArray(domains, DomainSpec.class);
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:activeDirectoryDomainName")
    public String getActiveDirectoryDomainName(URI domainManager) throws Exception {
        String name = this._systemManagementService.getDomainName();
        return name;
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:sslIdentity")
    public X509Spec[] getSslIdentity(URI domainManager, String rawUrl) throws Exception {
        ArrayList<X509Spec> results = new ArrayList<X509Spec>();
        URI uri = new URI(rawUrl);
        ConfigurationManagementService.CertificateChain chain = this._domainManagementService.getSslIdentity(uri);
        for (String rawCertificate : chain.certificates) {
            X509Certificate certificate = CertificateUtil.decodeCertificate((String)rawCertificate);
            X509Spec resultSpec = new X509Spec(certificate);
            results.add(resultSpec);
        }
        return results.toArray(new X509Spec[results.size()]);
    }
}

