/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.model.X509RemovalSpec;
import com.vmware.vsphere.client.sso.admin.model.X509UsageInfo;
import com.vmware.vsphere.client.sso.admin.model.X509UsageSpec;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainManagerMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DomainManagerMutationProvider.class);
    private final IdentitySourceDomainManagementService _domainManagementService;

    public DomainManagerMutationProvider(SsoService ssoService, IdentitySourceDomainManagementService managementService) {
        this._domainManagementService = managementService;
    }

    @type(value="sso:DomainManager")
    public OperationResult remove(URI ref, X509RemovalSpec spec) {
        OperationResult result = new OperationResult();
        try {
            boolean removeOk = this._domainManagementService.removeExternalDomainCertificate(spec.thumbprint);
            result.result = removeOk;
        }
        catch (Exception e) {
            _logger.error((Object)"remove(URI, X509RemovalSpec)", (Throwable)e);
            result.error = SsoAdminUtil.getOperationResultError(e);
        }
        return result;
    }

    @type(value="sso:DomainManager")
    public ValidationResult[] validateMultiSpec(URI ref, X509UsageSpec[] specs) throws SsoServiceException, NotAuthenticated, NoPermission, InvalidCredentials, ADIDSAlreadyExistFault {
        if (ArrayUtil.isNullOrEmpty((Object[])specs)) {
            return new ValidationResult[0];
        }
        Map<String, String> domainsByThumb = this._domainManagementService.getExternalDomainsCertificateUsage(specs);
        String errorToReport = domainsByThumb.get("error");
        ServiceFault exceptionToReport = null;
        if (errorToReport != null) {
            exceptionToReport = new ServiceFault();
            exceptionToReport.setMessage(errorToReport);
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(specs.length);
        for (X509UsageSpec spec : specs) {
            String domainName = domainsByThumb.get(spec.thumbprint);
            X509UsageInfo usage = new X509UsageInfo();
            usage.thumbprint = spec.thumbprint;
            usage.usedByDomain = domainName;
            ValidationResult result = new ValidationResult();
            if ("?".equals(usage.usedByDomain)) {
                result.error = exceptionToReport;
            } else {
                result.result = usage;
            }
            results.add(result);
        }
        return (ValidationResult[])ArrayUtil.toArray(results, ValidationResult.class);
    }
}

