/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.AuthnPolicy;
import com.vmware.vim.binding.sso.admin.fault.CertificateDeletionFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.ConfigurationManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManagementServiceImpl
extends AdminServiceBase
implements ConfigurationManagementService {
    private static final Log _logger = LogFactory.getLog(ConfigurationManagementServiceImpl.class);

    public ConfigurationManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer transformer) {
        super(ssoService, ssoServiceManager, transformer);
    }

    public String[] getTrustedCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        return this.getAdminService(session).getConfigurationManagementService().getTrustedCertificates();
    }

    public String[] getIssuersCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession session = SessionUtil.getHttpSession();
        return this.getAdminService(session).getConfigurationManagementService().getIssuersCertificates();
    }

    boolean deleteTrustedCertificate(String thumbprint) throws CertificateDeletionFault, NotAuthenticated, NoPermission, InvalidCredentials, SsoServiceException {
        _logger.debug((Object)("deleteTrustedCertificate: " + thumbprint));
        HttpSession session = SessionUtil.getHttpSession();
        boolean result = this.getAdminService(session).getConfigurationManagementService().deleteTrustedCertificate(thumbprint);
        _logger.debug((Object)("deleteTrustedCertificate result = " + (result ? "true" : "false")));
        return result;
    }

    @Override
    public AuthnPolicy getAuthnPolicy() throws SsoServiceException {
        AuthnPolicy authnPolicy = null;
        try {
            HttpSession session = SessionUtil.getHttpSession();
            authnPolicy = this.getAdminService(session).getConfigurationManagementService().getAuthnPolicy();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception occured while getting SSO authentication policy", (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
        return authnPolicy;
    }

    @Override
    public void setAuthnPolicy(AuthnPolicy authnPolicy) throws Exception {
        try {
            HttpSession session = SessionUtil.getHttpSession();
            this.getAdminService(session).getConfigurationManagementService().setAuthnPolicy(authnPolicy);
        }
        catch (Exception e) {
            _logger.error((Object)"Exception occured while setting SSO authentication policy", (Throwable)e);
            throw new SsoServiceException((Throwable)e);
        }
    }
}

