/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin;

import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.exception.SsoBackendException;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.PasswordSpec;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(SsoMutationProvider.class);
    private final PrincipalManagementServiceImpl _principalManagementServiceImpl;
    private final BackendExceptionTransformer _exceptionTransformer;

    public SsoMutationProvider(PrincipalManagementServiceImpl principalManagementService, BackendExceptionTransformer transformer) {
        this._principalManagementServiceImpl = principalManagementService;
        this._exceptionTransformer = transformer;
    }

    public OperationResult apply(ManagedObjectReference ref, PasswordSpec spec) {
        OperationResult result = new OperationResult();
        ref.setType("vsphere:client");
        result.entity = ref;
        try {
            this._principalManagementServiceImpl.changePassword(spec.oldPassword, spec.newPassword);
        }
        catch (Exception e) {
            _logger.error((Object)"apply(ManagedObjectReference, PasswordSpec)", (Throwable)e);
            result.error = this.getLocalizedOperationResultError(e);
        }
        return result;
    }

    private Exception getOperationResultError(Exception e) {
        if (e instanceof SsoBackendException) {
            return e;
        }
        return this._exceptionTransformer.transformException(e);
    }

    private Exception getLocalizedOperationResultError(Exception e) {
        Exception result = this.getOperationResultError(e);
        if (result instanceof PasswordPolicyViolationFault) {
            PasswordPolicyViolationFault passwordPolicyViolationFault = (PasswordPolicyViolationFault)result;
            passwordPolicyViolationFault.setMessage(SsoAdminUtil.getString("sso.admin.password.policyViolation.error", new String[0]));
            return passwordPolicyViolationFault;
        }
        return result;
    }
}

