/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapp.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.vApp.ProductInfo;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceIconData;

@QueryBinding(value="VirtualApp")
public final class VAppSummaryData
extends BaseSummaryData
implements ResourceIconData {
    @Property(value="VirtualApp/vAppConfig/product")
    ProductInfo[] products;
    @Property(value="VirtualApp/summary/quickStats/guestMemoryUsage")
    long memoryUsageMb;
    @Property(value="VirtualApp/summary/quickStats/overallCpuUsage")
    long cpuUsageMhz;

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        ProductInfo product = this.products[0];
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("VAppSummaryView.product", this.format(product.name)), new BaseSummaryData.LabelValue("VAppSummaryView.vendor", this.format(product.vendor)), new BaseSummaryData.LabelValue("VAppSummaryView.version", this.format(product.version))};
    }

    @Override
    public ResourceIconData.ResourceIcon[] getResourceIcons() {
        String cpuUsed = FormatUtil.getFrequencyFormatted((Number)this.cpuUsageMhz, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        String memoryUsed = FormatUtil.getStorageFormatted((Long)this.memoryUsageMb, (long)0x100000L, (long)-1L);
        return new ResourceIconData.ResourceIcon[]{new ResourceIconData.ResourceIcon("summary.cpuUsage", cpuUsed, "vsphere-icon-cpu-summary"), new ResourceIconData.ResourceIcon("summary.memoryUsage", memoryUsed, "vsphere-icon-memory-summary")};
    }

    public BaseSummaryData.Badge[] getBadges() {
        return new BaseSummaryData.Badge[0];
    }

    private String format(String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return "--";
        }
        return value;
    }
}

