/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ProviderSummaryData;
import java.util.ArrayList;

@QueryBinding(value="ClusterComputeResource")
public final class ClusterSummaryData
extends ProviderSummaryData {
    @Property(value="ClusterComputeResource/summary/numCpuCores")
    private short numProcessors;
    @Property(value="ClusterComputeResource/summary/numVmotions")
    private int numVMotionMigrations;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    private boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/enabled")
    private boolean haEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/enabled")
    private boolean dpmEnabled;
    @Property(value="ClusterComputeResource/summary/currentEVCModeKey")
    private String evcStatus;
    @Property(value="ClusterComputeResource/configurationEx/vsanConfigInfo/enabled")
    private boolean vsanEnabled;
    @Relationship(value={"ClusterComputeResource/host"})
    @Property(value="HostSystem/config/vsanHostConfig/faultDomainInfo/name")
    private String[] vsanFaultDomains;

    @Override
    protected long getStorageUnit() {
        return 0x100000L;
    }

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        ArrayList<BaseSummaryData.LabelValue> summaryItemPairs = new ArrayList<BaseSummaryData.LabelValue>();
        summaryItemPairs.add(new BaseSummaryData.LabelValue("clusterSummaryProperties.NumProcessors", this.numProcessors));
        summaryItemPairs.add(new BaseSummaryData.LabelValue("clusterSummaryProperties.NumVMotionMigrations", this.numVMotionMigrations));
        if (this.vsanEnabled && this.vsanFaultDomains != null && this.vsanFaultDomains.length > 0) {
            String faultDomainValue = String.join((CharSequence)", ", this.vsanFaultDomains);
            BaseSummaryData.LabelValue faultDomainItem = new BaseSummaryData.LabelValue("summaryView.faultDomains", faultDomainValue);
            faultDomainItem.feature = Feature.UI_Multi_AZ.value();
            summaryItemPairs.add(faultDomainItem);
        }
        return summaryItemPairs.toArray(new BaseSummaryData.LabelValue[0]);
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.drsEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-distributedResourceScheduler24", "clusterSummaryFeatures.DRS", false));
        }
        if (this.haEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-highAvailability24", "clusterSummaryFeatures.HA", false));
        }
        if (this.dpmEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-distributedPowerManagement24", "clusterSummaryFeatures.DPM", false));
        }
        if (!StringUtil.isNullOrEmpty((String)this.evcStatus)) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-evcEnabled24", "clusterSummaryFeatures.EVC", false));
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }

    void setvSanProperties(boolean enabled, String[] faultDomains) {
        this.vsanEnabled = enabled;
        this.vsanFaultDomains = faultDomains;
    }
}

