/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import com.vmware.vise.mvc.tree.TreeNodeStateManager;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.mvc.tree.TreePathHelper;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreeManagerImpl
implements TreeManager {
    private static final Log _logger = LogFactory.getLog(TreeManagerImpl.class);
    private static final List<String> OBJECT_PROPERTIES = new ArrayList<String>(){
        {
            this.add("name");
            this.add("labelIds");
            this.add("primaryIconId");
            this.add("@modelKey");
        }
    };
    private static final List<String> VM_PROPERTIES = new ArrayList<String>(){
        {
            this.add("name");
            this.add("labelIds");
            this.add("primaryIconId");
            this.add("config.template");
            this.add("@modelKey");
        }
    };
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    private final I18nManager _i18nManager;
    private final TreeList _treeList;
    private final TreeNodeList _treeNodeList;
    private final TreePathHelper _treePathHelper;
    private final TreeNodeStateManager _treeNodeStateManager;
    private final QueryService _queryService;
    private final boolean _multiAZFeatureEnabled;

    @Autowired
    public TreeManagerImpl(ObjectReferenceService objRefService, DataService dataService, I18nManager i18nManager, TreeList treeList, TreeNodeList treeNodeList, TreePathHelper treePathHelper, TreeNodeStateManager treeNodeStateManager, QueryServiceFactory queryServiceFactory, FeatureStateService featureStateService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRefService, dataService, i18nManager, treeList, treeNodeList, treePathHelper});
        this._objRefService = objRefService;
        this._dataService = dataService;
        this._i18nManager = i18nManager;
        this._treeList = treeList;
        this._treeNodeList = treeNodeList;
        this._treePathHelper = treePathHelper;
        this._treeNodeStateManager = treeNodeStateManager;
        this._queryService = queryServiceFactory.getQueryService();
        this._multiAZFeatureEnabled = featureStateService.isEnabled(Feature.UI_Multi_AZ);
    }

    @Override
    public List<TreeNodeItem> getRoot(String treeId, String objectId) {
        Tree tree = this._treeList.getTree(treeId);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared: " + treeId);
        }
        TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(tree.getRoot());
        if (treeNodeSpec == null) {
            throw new IllegalStateException("No such treeNodeSpec declared");
        }
        if (this.isTreeWithVcRoot(tree.getRoot(), objectId)) {
            return this.getVcRoot(treeNodeSpec.getId());
        }
        Object ref = null;
        if (!StringUtil.isNullOrEmpty((String)objectId) && (ref = this._objRefService.getReference(objectId, true)) == null) {
            _logger.warn((Object)String.format("No root reference found: [treeId=%s, objectId=%s]", treeId, objectId));
        }
        QuerySpec[] qs = new QuerySpec[]{treeNodeSpec.getQuerySpec(ref)};
        Response response = this.retrieveDataFromDs(qs);
        List<TreeNodeItem> result = this.formatResult(tree, response);
        return result;
    }

    @Override
    public List<TreeNodeItem> getChildren(String treeId, String nodeTypeId, String parentRef) {
        String[] filteredTypes;
        Tree tree = this._treeList.getTree(treeId);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared");
        }
        String[] children = tree.getChildren(nodeTypeId);
        if (children == null) {
            _logger.info((Object)String.format("No children for tree:[%s] and nodeType:[%s]", treeId, nodeTypeId));
            return new ArrayList<TreeNodeItem>();
        }
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        Object parent = this._objRefService.getReference(parentRef, true);
        if (parent == null) {
            _logger.warn((Object)String.format("Possibly unexpected null MOR of the parent: [treeId=%s, nodeId=%s, parentRef=%s]", treeId, nodeTypeId, parentRef));
        }
        for (String child : filteredTypes = this._treeNodeStateManager.filterHidden(treeId, children, this.getNodeTypes(children))) {
            TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(child);
            if (treeNodeSpec == null) {
                throw new IllegalStateException("No such treeNodeSpec declared");
            }
            querySpecs.add(treeNodeSpec.getQuerySpec(parent));
        }
        Response response = this.retrieveDataFromDs(querySpecs.toArray(new QuerySpec[0]));
        return this.formatResult(tree, response);
    }

    @Override
    public TreePath getPath(String treeId, String rootId, String objectId, String options) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{treeId, objectId});
        Object object = this._objRefService.getReference(objectId, true);
        Object root = null;
        if (rootId == null) {
            if (this.isOptimizedPathToRootAvailable(object, treeId)) {
                root = this.getOptimizedRootRef(object);
            } else {
                List<TreeNodeItem> rootList = this.getRoot(treeId, null);
                String objectVcGuid = this._objRefService.getServerGuid(object);
                for (TreeNodeItem nodeItem : rootList) {
                    Object rootNodeRef = this._objRefService.getReference(nodeItem.objRef, true);
                    if (objectVcGuid == null || !objectVcGuid.equals(this._objRefService.getServerGuid(rootNodeRef))) continue;
                    root = rootNodeRef;
                    break;
                }
                if (root == null) {
                    _logger.info((Object)String.format("No root items for tree:[%s]", treeId));
                    TreePath treePath = new TreePath();
                    treePath.options = options;
                    treePath.paths = Collections.emptyList();
                    return treePath;
                }
            }
        } else {
            root = this._objRefService.getReference(rootId, true);
        }
        TreePath treePaths = this._treePathHelper.findPaths(treeId, root, object, options);
        return treePaths;
    }

    @Override
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(List<String> objectIds) {
        HashMap<String, Map<String, Object>> propertiesByObjectId = new HashMap<String, Map<String, Object>>();
        if (ArrayUtil.isNullOrEmpty(objectIds)) {
            return propertiesByObjectId;
        }
        HashMap objectsByType = new HashMap(objectIds.size());
        for (String objectId : objectIds) {
            String objectType;
            Object objectReference = this._objRefService.getReference(objectId, true);
            if (objectReference == null || (objectType = this._objRefService.getResourceObjectType(objectReference)) == null) continue;
            if (!objectsByType.containsKey(objectType)) {
                objectsByType.put(objectType, new ArrayList());
            }
            ((List)objectsByType.get(objectType)).add(objectReference);
        }
        String queryName = "TreeManagerImpl.getPropertiesByObjectIds";
        for (String objectType : objectsByType.keySet()) {
            List<String> propertiesToRequest = objectType.equals(TreeManager.TARGET_VIRTUALMACHINE) ? VM_PROPERTIES : OBJECT_PROPERTIES;
            ResultSet resultSet = this._queryService.select(propertiesToRequest).from(new String[]{objectType}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objectsByType.get(objectType))}).opId(queryName).fetch();
            for (ResourceItem resourceItem : resultSet.getItems()) {
                String objectId;
                Object objRef = resourceItem.getKey();
                if (objRef == null || (objectId = this._objRefService.getUid(objRef, true)) == null) continue;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (String property : propertiesToRequest) {
                    if (property.equals("@modelKey")) continue;
                    properties.put(property, resourceItem.get(property));
                }
                propertiesByObjectId.put(objectId, properties);
            }
        }
        return propertiesByObjectId;
    }

    @Override
    public List<String> getSupportedTypes(String treeId) {
        return this._treeList.getSupportedTypes(treeId);
    }

    private Response retrieveDataFromDs(QuerySpec[] querySpecs) {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs;
        Response response = this._dataService.getData(requestSpec);
        return response;
    }

    private List<TreeNodeItem> formatResult(Tree tree, Response response) {
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>();
        if (response == null) {
            return resultList;
        }
        com.vmware.vise.data.query.ResultSet[] resultSet = response.resultSet;
        if (resultSet == null) {
            return resultList;
        }
        Locale locale = ResourceUtil.getLocale();
        Map resourceMapByBundle = this._i18nManager.getResourceMap(locale);
        for (com.vmware.vise.data.query.ResultSet dsResult : resultSet) {
            resultList.addAll(this.formatResult(tree, dsResult, resourceMapByBundle));
        }
        return resultList;
    }

    private List<TreeNodeItem> formatResult(Tree tree, com.vmware.vise.data.query.ResultSet dsResult, Map<String, Map<String, String>> resourceMapByBundle) {
        ResultItem[] items;
        ArrayList<TreeNodeItem> resultList = new ArrayList<TreeNodeItem>();
        if (dsResult.error != null) {
            _logger.error((Object)String.format("Error when getting data from dataservice [treeId=%s]: %s", tree.getId(), dsResult.error.getMessage()), dsResult.error.getCause());
        }
        if ((items = dsResult.items) == null || items.length == 0) {
            return resultList;
        }
        resultList.ensureCapacity(items.length);
        for (ResultItem item : items) {
            TreeNodeItem node = new TreeNodeItem();
            String uid = this._objRefService.getUid(item.resourceObject, true);
            if (uid == null) {
                _logger.warn((Object)String.format("Possibly unexpected null uid: [treeId=%s, nodeId=%s]", tree.getId(), dsResult.queryName));
            }
            node.objRef = uid;
            node.nodeTypeId = dsResult.queryName;
            if (tree.hasChildren(dsResult.queryName)) {
                node.hasChildren = Boolean.TRUE;
            }
            String labelIds = null;
            boolean vsanEnabled = false;
            String vsanFaultDomains = null;
            for (PropertyValue prop : item.properties) {
                String objectId;
                String propName = prop.propertyName;
                if (StringUtil.isNullOrEmpty((String)propName)) {
                    _logger.error((Object)String.format("Found a null or empty propertyName for: [treeId=%s, nodeId=%s,  uid=%s]", tree.getId(), dsResult.queryName, uid));
                    continue;
                }
                String propValue = prop.value.toString();
                if (propName.equalsIgnoreCase("name")) {
                    node.text = propValue;
                    continue;
                }
                if (propName.equalsIgnoreCase("primaryIconId")) {
                    node.spriteCssClass = propValue;
                    continue;
                }
                if (propName.equalsIgnoreCase("labelIds")) {
                    labelIds = CommonUtils.getTaggingLabel(propValue, resourceMapByBundle, null, null);
                    continue;
                }
                if (propName.equalsIgnoreCase("config.template")) {
                    node.isVmTemplate = Boolean.parseBoolean(propValue);
                    continue;
                }
                if (propName.equalsIgnoreCase("config.vsanHostConfig.enabled")) {
                    vsanEnabled = Boolean.parseBoolean(propValue);
                    continue;
                }
                if (propName.equalsIgnoreCase("config.vsanHostConfig.faultDomainInfo.name")) {
                    vsanFaultDomains = propValue;
                    continue;
                }
                if (node.aliases == null) {
                    node.aliases = new ArrayList<String>();
                }
                if (StringUtil.isNullOrEmpty((String)(objectId = this._objRefService.getUid(prop.value, true)))) continue;
                node.aliases.add(objectId);
            }
            String italic = "italic";
            String _disconnected = "disconnected";
            String _inaccessible = "inaccessible";
            String _error = "error";
            node.spriteParentCssClass = "";
            if (node.spriteCssClass != null) {
                if (node.spriteCssClass.indexOf(_disconnected) != -1 || node.spriteCssClass.indexOf(_inaccessible) != -1 || node.spriteCssClass.indexOf(_error) != -1) {
                    node.spriteParentCssClass = node.spriteParentCssClass + " " + italic;
                } else {
                    node.spriteParentCssClass.replaceAll(italic, "");
                }
            }
            if (labelIds != null) {
                node.text = node.text + labelIds;
                if (labelIds.indexOf(_disconnected) != -1) {
                    node.spriteParentCssClass = node.spriteParentCssClass + " " + italic;
                }
            }
            if (this._multiAZFeatureEnabled && vsanEnabled && vsanFaultDomains != null && vsanFaultDomains.length() > 0) {
                node.text = node.text + " (" + vsanFaultDomains + ")";
            }
            resultList.add(node);
        }
        return resultList;
    }

    private ManagedObjectReference getOptimizedRootRef(Object obj) {
        boolean isMor = obj instanceof ManagedObjectReference;
        if (!isMor) {
            throw new IllegalArgumentException("Unsupported object type!");
        }
        ManagedObjectReference object = (ManagedObjectReference)obj;
        ManagedObjectReference root = ManagedObjectUtil.getRootFolder((String)object.getServerGuid());
        return root;
    }

    private boolean isOptimizedPathToRootAvailable(Object object, String treeId) {
        boolean isMor = object instanceof ManagedObjectReference;
        return isMor && this._treePathHelper.isOptimizedPathToRootAvailable(treeId) && VcServiceUtil.is65VcOrLaterByServerGuid((String)((ManagedObjectReference)object).getServerGuid(), (boolean)true);
    }

    private boolean isTreeWithVcRoot(String treeRoot, String objectId) {
        return TreeNodeList.VcRoot.class.getSimpleName().equals(treeRoot) || StringUtil.isNullOrEmpty((String)objectId) && TreeNodeList.RefOrVcAsRoot.class.getSimpleName().equals(treeRoot);
    }

    private List<TreeNodeItem> getVcRoot(String nodeTypeId) {
        Collection vcServices;
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (registry == null) {
            return Collections.emptyList();
        }
        ArrayList<TreeNodeItem> rootNodes = new ArrayList<TreeNodeItem>();
        try {
            vcServices = VcServiceUtil.retrieveServiceNames((LinkedVcGroupRegistry)registry);
        }
        catch (InterruptedException e) {
            _logger.error((Object)("Cannot retrieve vCenter names: " + e.getMessage()));
            return Collections.emptyList();
        }
        for (VcService vc : vcServices) {
            if (vc == null) continue;
            String vCenterName = vc.getServiceName(false);
            ManagedObjectReference rootFolder = ManagedObjectUtil.getRootFolder((String)vc.getServiceGuid());
            TreeNodeItem node = new TreeNodeItem();
            node.objRef = this._objRefService.getUid((Object)rootFolder, true);
            node.hasChildren = true;
            node.spriteCssClass = "vsphere-icon-vcenter";
            node.text = vCenterName;
            node.nodeTypeId = nodeTypeId;
            rootNodes.add(node);
        }
        TreeManagerImpl.sortRootNodes(rootNodes);
        return rootNodes;
    }

    private String[] getNodeTypes(String[] nodeIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            result.add(this.getNodeType(nodeId));
        }
        return result.toArray(new String[0]);
    }

    private String getNodeType(String nodeId) {
        TreeNodeSpec nodeSpec = this._treeNodeList.getTreeNodeSpec(nodeId);
        Constraint constraint = nodeSpec.getConstraint(nodeId);
        if (constraint instanceof CompositeConstraint && TARGET_VIRTUALMACHINE.equals(constraint.targetType)) {
            CompositeConstraint composite = (CompositeConstraint)constraint;
            for (Constraint nested : composite.nestedConstraints) {
                if (!(nested instanceof PropertyConstraint)) continue;
                PropertyConstraint propertyConstraint = (PropertyConstraint)nested;
                Comparator comparator = propertyConstraint.comparator;
                if (!propertyConstraint.propertyName.equals("config.template") || !comparator.equals((Object)Comparator.EQUALS) || !propertyConstraint.comparableValue.equals(true)) continue;
                return "VmTemplate";
            }
        }
        return constraint.targetType;
    }

    private static void sortRootNodes(List<TreeNodeItem> nodes) {
        Collections.sort(nodes, new java.util.Comparator<TreeNodeItem>(){

            @Override
            public int compare(@Nonnull TreeNodeItem o1, @Nonnull TreeNodeItem o2) {
                return o1.text.compareToIgnoreCase(o2.text);
            }
        });
    }
}

