/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tasks;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;

public class TaskQueryUtil {
    public static final String TASK_TYPE_NAME = "Task";
    public static final String MANAGED_ENTITY = "ManagedEntity";

    public static QuerySpec createTaskQuerySpec(Object relatedObject, boolean activeTasks, boolean recentTasks, String[] rootTaskKeys, String userName, int pageSize, int requestedPage) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propSpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = pageSize;
        CompositeConstraint constraint = TaskQueryUtil.createTaskSearchConstraint(relatedObject, activeTasks, recentTasks, rootTaskKeys, userName, requestedPage);
        constraint.targetType = TASK_TYPE_NAME;
        resourceSpec.constraint = constraint;
        propSpec.propertyNames = new String[1];
        propSpec.propertyNames[0] = "info";
        propSpec.type = MANAGED_ENTITY;
        resourceSpec.propertySpecs = new PropertySpec[1];
        resourceSpec.propertySpecs[0] = propSpec;
        querySpec.name = "vsphere:Task-info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    public static CompositeConstraint createTaskSearchConstraint(Object obj, boolean activeTasks, boolean recentTasks, String[] rootTaskKeys, String userName, Integer requestedPage) {
        PropertyConstraint property;
        CompositeConstraint constraint = new CompositeConstraint();
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraint.conjoiner = Conjoiner.AND;
        constraint.targetType = "vsphere:Task";
        if (recentTasks) {
            property = TaskQueryUtil.createPropertyConstraint("info.recentTasks", recentTasks, null);
            constraints.add((Constraint)property);
        }
        if (obj != null) {
            property = TaskQueryUtil.createPropertyConstraint("info.entity", obj, null);
            constraints.add((Constraint)property);
        }
        if (activeTasks) {
            property = TaskQueryUtil.createPropertyConstraint("info.activeTasks", activeTasks, null);
            constraints.add((Constraint)property);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])rootTaskKeys)) {
            property = TaskQueryUtil.createPropertyConstraint("info.rootTasks", rootTaskKeys, null);
            constraints.add((Constraint)property);
        }
        if (!StringUtil.isNullOrEmpty((String)userName)) {
            TaskQueryUtil.applyUserName(constraints, userName);
        }
        if (requestedPage != null) {
            property = TaskQueryUtil.createPropertyConstraint("info.currentPage", requestedPage, null);
            constraints.add((Constraint)property);
        }
        constraint.nestedConstraints = constraints.toArray(new Constraint[constraints.size()]);
        return constraint;
    }

    public static PropertyConstraint createPropertyConstraint(String propertyName, Object comparableValue, String targetType) {
        if (targetType == null) {
            targetType = "vsphere:Task";
        }
        PropertyConstraint property = new PropertyConstraint();
        property.propertyName = propertyName;
        property.comparableValue = comparableValue;
        property.targetType = targetType;
        property.comparator = Comparator.EQUALS;
        return property;
    }

    private static void applyUserName(ArrayList<Constraint> constraints, String userName) {
    }
}

