/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vise.vim.common.vapi.localization.VapiLocalizationUtil;
import java.io.IOException;
import java.util.List;

public class VapiLocalizableMessageSerializer
extends StdSerializer<LocalizableMessage> {
    protected static final String ID_FIELD_NAME = "id";
    protected static final String DEFAULT_MESSAGE_FIELD_NAME = "defaultMessage";
    protected static final String ARGS_FIELD_NAME = "args";

    VapiLocalizableMessageSerializer() {
        this(null);
    }

    VapiLocalizableMessageSerializer(Class<LocalizableMessage> t) {
        super(t);
    }

    public void serialize(LocalizableMessage localizedMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        LocalizableMessage instance = this.getInstanceToSerialize(localizedMessage);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(ID_FIELD_NAME, instance.getId());
        jsonGenerator.writeStringField(DEFAULT_MESSAGE_FIELD_NAME, instance.getDefaultMessage());
        jsonGenerator.writeArrayFieldStart(ARGS_FIELD_NAME);
        List args = instance.getArgs();
        if (args != null) {
            for (String arg : args) {
                jsonGenerator.writeString(arg);
            }
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private LocalizableMessage getInstanceToSerialize(LocalizableMessage instance) {
        String localizedMessage = VapiLocalizationUtil.getLocalizedMessage((LocalizableMessage)instance);
        instance.setDefaultMessage(localizedMessage);
        return instance;
    }
}

