/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vmware.vise.mvc.search.model.FilterCriteria;
import com.vmware.vise.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ValueDeserializer
extends StdDeserializer<Object> {
    private static final Log _logger = LogFactory.getLog(ValueDeserializer.class);

    ValueDeserializer() {
        this(null);
    }

    ValueDeserializer(Class<?> vc) {
        super(vc);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        FilterCriteria filterCriteria = (FilterCriteria)jsonParser.getParsingContext().getParent().getCurrentValue();
        if (jsonParser.isExpectedStartObjectToken()) {
            return this.parseObject(jsonParser, filterCriteria.type);
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonNode nodes = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            ArrayList<String> values = new ArrayList<String>();
            for (JsonNode node : nodes) {
                values.add(node.asText());
            }
            return values;
        }
        return jsonParser.getValueAsString();
    }

    private Object parseObject(JsonParser jsonParser, String className) throws IOException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)StringUtil.appendStrings((Object[])new Object[]{"Failed to find class for ", className, e.getMessage()}));
            throw new RuntimeException(e.getMessage());
        }
        return new ObjectMapper().readValue(jsonParser, clazz);
    }
}

