/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator.interpreter;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.mvc.model.ObjectSpec;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.mvc.objectnavigator.util.ObjectNavigatorUtil;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeStateManager;
import com.vmware.vise.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ObjectNodeNavReqInterpreter
implements NavigationRequestInterpreter {
    private static final Log _logger = LogFactory.getLog(ObjectNodeNavReqInterpreter.class);
    private static final String SERVER_EXTENSION_ID = "vsphere.core.inventory.serverObjectViewsExtension";
    private static final String RELATED_ITEMS_VIEW = "resources/ui/views/objectnavigator/RelatedItemsView.html";
    private static final String OBJECT_NOT_FOUND_VIEW = "resources/ui/views/objectnavigator/error/ObjectNotFound.html";
    private static final String TREE_ID = "tree";
    private static final String TREE_VISIBILITY_STATE_CHANGED = "treeVisibilityStateChanged";
    private static final String VMS_AUTO_SHOWN = "vmsAutoShown";
    private final ObjectReferenceService _objRefService;
    private final ObjectNavigatorManager _objectNavigatorManager;
    private final QueryService _queryService;
    private final TreeNodeStateManager _treeNodeStateManager;
    private final ObjectSpec _relatedItemSpec = new ObjectSpec();
    private final ObjectSpec _notFoundObjectSpec = new ObjectSpec();

    @Autowired
    public ObjectNodeNavReqInterpreter(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ObjectNavigatorManager objectNavigatorManager, QueryServiceFactory queryServiceFactory, TreeNodeStateManager treeNodeStateManager) {
        this._objRefService = objectReferenceService;
        this._objectNavigatorManager = objectNavigatorManager;
        this._queryService = queryServiceFactory.getQueryService();
        this._treeNodeStateManager = treeNodeStateManager;
        this._relatedItemSpec.url = RELATED_ITEMS_VIEW;
        this._notFoundObjectSpec.url = OBJECT_NOT_FOUND_VIEW;
    }

    @Override
    public NavigationResponse interpretNavigationRequest(NavigationRequest navRequest) {
        if (!this.isRequestValid(navRequest)) {
            return null;
        }
        NavigationResponse response = this.checkAndCreateNavigationResponseForObjectNotFound(navRequest);
        if (response != null) {
            return response;
        }
        if (StringUtil.isNullOrEmpty((String)navRequest.navigator)) {
            return this.createNavResponseForFocusedObject(navRequest);
        }
        NavigationResponse navResponse = this.createNavigationResponseForObjectInTree(navRequest);
        return navResponse;
    }

    private boolean showVmsIfNeeded(NavigationResponse navResponse, String navigatorId, ResourceItem vmProps) {
        if (navResponse.viewSpec == null) {
            return false;
        }
        if (navResponse.viewSpec.metadata == null) {
            navResponse.viewSpec.metadata = new HashMap();
        } else {
            navResponse.viewSpec.metadata.remove(TREE_VISIBILITY_STATE_CHANGED);
        }
        boolean vmsAutoSwitchedToVisible = false;
        if ("vsphere.core.viTree.hostsAndClustersView".equals(navigatorId) && vmProps != null && vmProps.get("parent") == null && (vmsAutoSwitchedToVisible = this.showNodesInTreeIfHidden("vsphere.core.physicalInventorySpec", "VirtualMachine"))) {
            navResponse.viewSpec.metadata.put(TREE_VISIBILITY_STATE_CHANGED, VMS_AUTO_SHOWN);
        }
        return vmsAutoSwitchedToVisible;
    }

    private boolean showNodesInTreeIfHidden(String treeId, String nodeType) {
        Map<String, Boolean> nodesVisibilityState = this._treeNodeStateManager.getVisibilityState(treeId, new String[]{nodeType});
        if (!nodesVisibilityState.get(nodeType).booleanValue()) {
            nodesVisibilityState.put(nodeType, true);
            return this._treeNodeStateManager.setVisibilityState(treeId, nodesVisibilityState);
        }
        return false;
    }

    private boolean isRequestValid(NavigationRequest navRequest) {
        String rootViewExtensionId;
        if (StringUtil.isNullOrEmpty((String)navRequest.contextObject)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("interpretNavigationRequest(): Null context object set. Target extension id=" + navRequest.targetViewId));
            }
            return false;
        }
        ExtensionInfo rootExtension = ObjectNavigatorUtil.getRootExtension(navRequest.extensionPaths);
        String string = rootViewExtensionId = rootExtension != null ? rootExtension.getId() : null;
        if (!SERVER_EXTENSION_ID.equals(navRequest.targetViewId) && !SERVER_EXTENSION_ID.equals(rootViewExtensionId)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)new StringBuilder(200).append("interpretNavigationRequest(): Target or root extension id not SERVER_EXTENSION_ID. targetExtensionID=").append(navRequest.targetViewId).append(", rootViewExtensionId=").append(rootViewExtensionId).toString());
            }
            return false;
        }
        return true;
    }

    private NavigationResponse checkAndCreateNavigationResponseForObjectNotFound(NavigationRequest navRequest) {
        Object reference = this._objRefService.getReference(navRequest.contextObject, true);
        if (reference == null || !this.objectExists(reference)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)new StringBuilder(200).append("interpretNavigationRequest(): Context object is not a valid resource ref. Target extension id=").append(navRequest.targetViewId).append(", objectId=").append(navRequest.contextObject).toString());
            }
            return this.createNavigationResponse(navRequest.contextObject, this._notFoundObjectSpec);
        }
        return null;
    }

    private boolean objectExists(Object reference) {
        String refType = this._objRefService.getResourceObjectType(reference);
        ResultSet result = this._queryService.select(new String[0]).withTotalCount().from(new String[]{refType}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, reference).limit(0).fetch();
        return result.getTotalCount() != 0;
    }

    private NavigationResponse createNavResponseForFocusedObject(NavigationRequest navRequest) {
        NavigationResponse navResponse = this.createNavigationResponse(navRequest.contextObject, this._relatedItemSpec);
        return navResponse;
    }

    private NavigationResponse createNavigationResponseForObjectInTree(NavigationRequest navRequest) {
        ObjectNavigatorNodeSpec navigatorNode;
        String navigatorId = navRequest.navigator;
        String treeId = null;
        ResourceItem vmProps = null;
        if (navigatorId.equals(TREE_ID)) {
            Object objectRef = this._objRefService.getReference(navRequest.contextObject, true);
            String objectType = this._objRefService.getResourceObjectType(objectRef);
            if (TreeManager.TARGET_VIRTUALMACHINE.equals(objectType)) {
                vmProps = this.getVmProperties(navRequest.contextObject);
                treeId = TreeList.getAssociatedTreeIdForVm(vmProps, navRequest.prevNavigator, this._treeNodeStateManager);
            }
            if (treeId == null) {
                treeId = TreeList.getAssociatedTreeIdForObject(objectRef, objectType, navRequest.prevNavigator);
            }
            if (treeId != null) {
                navigatorId = treeId;
            } else {
                NavigationResponse navResponse = this.createNavResponseForFocusedObject(navRequest);
                return navResponse;
            }
        }
        if ((navigatorNode = this.getObjectNavigatorNodeSpec(navigatorId)) == null) {
            _logger.warn((Object)("No focusable navigator node with ID: " + navRequest.navigator));
            return null;
        }
        NavigationResponse navResponse = this.createNavigationResponseWithTreeView(navigatorNode, navRequest.contextObject);
        this.showVmsIfNeeded(navResponse, navigatorId, vmProps);
        return navResponse;
    }

    private ResourceItem getVmProperties(String objectId) {
        Object object = this._objRefService.getReference(objectId, true);
        ResultSet result = this._queryService.select(new String[]{"parent", "config.template"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).fetch();
        if (!result.getItems().isEmpty()) {
            return (ResourceItem)result.getItems().get(0);
        }
        return null;
    }

    private ObjectNavigatorNodeSpec getObjectNavigatorNodeSpec(String nodeUid) {
        ObjectSpec viewSpec;
        List<ObjectNavigatorNodeSpec> nodeSpecs = this._objectNavigatorManager.getNodeSpecs();
        List<ObjectNavigatorNodeSpec> navigableNodeSpecs = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(nodeUid, nodeSpecs);
        ObjectNavigatorNodeSpec selectedNode = this._objectNavigatorManager.getNodeByNavigationTargetUid(nodeUid, navigableNodeSpecs);
        ObjectNavigatorNodeSpec nodeToBeFocused = selectedNode == null || selectedNode.isFocusable != false ? selectedNode : this._objectNavigatorManager.getClosestAncestorNodeThatCanBeFocused(selectedNode.getUid(), navigableNodeSpecs);
        ObjectSpec objectSpec = viewSpec = nodeToBeFocused != null ? nodeToBeFocused.getViewOpenedUponFocus() : null;
        if (viewSpec != null) {
            viewSpec.setUid(nodeToBeFocused.getUid());
        }
        return nodeToBeFocused;
    }

    private NavigationResponse createNavigationResponseWithTreeView(ObjectNavigatorNodeSpec navigatorNode, String selectedObject) {
        NavigationResponse navResponse = new NavigationResponse();
        navResponse.uid = navigatorNode.getUid();
        navResponse.title = navigatorNode.title;
        navResponse.icon = navigatorNode.icon;
        navResponse.viewSpec = navigatorNode.getViewOpenedUponFocus();
        navResponse.viewState = selectedObject != null ? ImmutableMap.of((Object)"selectedObject", (Object)selectedObject) : null;
        return navResponse;
    }

    private NavigationResponse createNavigationResponse(String context, ObjectSpec viewSpec) {
        NavigationResponse navResponse = new NavigationResponse();
        navResponse.uid = context;
        navResponse.viewSpec = viewSpec;
        return navResponse;
    }
}

