/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorNavigationManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.util.concurrent.annotation.GuardedBy;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectNavigatorNavigationManagerImpl
implements ObjectNavigatorNavigationManager {
    private static final String INTERFACE_NAME = NavigationRequestInterpreter.class.getName();
    private final ServiceRegistry _serviceRegistry;
    private final ExtensionService _extensionService;
    @GuardedBy(value="LOCK")
    private volatile List<NavigationRequestInterpreter> _interpreters;
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorNavigationManagerImpl.class);
    private final Object LOCK = new Object();
    private final ServiceListener _serviceListener;

    @Autowired
    public ObjectNavigatorNavigationManagerImpl(ServiceRegistry serviceRegistry, ExtensionService extensionService) {
        this._serviceRegistry = serviceRegistry;
        this._extensionService = extensionService;
        this._serviceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object service) {
                Object object = ObjectNavigatorNavigationManagerImpl.this.LOCK;
                synchronized (object) {
                    ObjectNavigatorNavigationManagerImpl.this.processNavRequestInterpreters();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object service) {
                Object object = ObjectNavigatorNavigationManagerImpl.this.LOCK;
                synchronized (object) {
                    ObjectNavigatorNavigationManagerImpl.this.processNavRequestInterpreters();
                }
            }
        };
        this.registerNavRequestInterpreters();
    }

    @Override
    public NavigationResponse handleNavigationRequest(String targetViewId, String context, String navigator, String prevNavigator) {
        if (this._interpreters == null) {
            throw new IllegalStateException("Interpreters have not been initialized");
        }
        NavigationResponse navResponse = null;
        for (NavigationRequestInterpreter interpreter : this._interpreters) {
            NavigationRequest navRequest = this.createNavigationRequest(targetViewId, context, navigator, prevNavigator);
            try {
                navResponse = interpreter.interpretNavigationRequest(navRequest);
            }
            catch (Exception e) {
                _logger.error((Object)("Error in interpreting request, interpreter=" + interpreter + " error: "), (Throwable)e);
            }
            if (navResponse == null) continue;
            return navResponse;
        }
        _logger.info((Object)new StringBuilder(200).append("handleNavigationRequest(). Could not interpret navigation request. targetID=").append(targetViewId).append(" ,context=").append(context).toString());
        return navResponse;
    }

    public void destroy() {
        this._serviceRegistry.unregisterServiceListener(INTERFACE_NAME, this._serviceListener);
    }

    private NavigationRequest createNavigationRequest(String targetViewId, String objectId, String navigator, String prevNavigator) {
        NavigationRequest navRequest = new NavigationRequest();
        navRequest.targetViewId = targetViewId;
        navRequest.contextObject = objectId;
        navRequest.navigator = navigator;
        navRequest.prevNavigator = prevNavigator;
        try {
            navRequest.extensionPaths = this._extensionService.getExtensionHosts(targetViewId);
        }
        catch (Exception e) {
            _logger.error((Object)"Error in querying extension paths.", (Throwable)e);
        }
        return navRequest;
    }

    private void registerNavRequestInterpreters() {
        this._serviceRegistry.registerServiceListener(INTERFACE_NAME, this._serviceListener);
    }

    private void processNavRequestInterpreters() {
        List interpreters = this._serviceRegistry.getServices(NavigationRequestInterpreter.class.getName());
        this._interpreters = new ArrayList<NavigationRequestInterpreter>(interpreters);
    }
}

