/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vsphere.client.usersession.UserSessionSSODomainInfo;
import com.vmware.vsphere.client.usersession.UserSessionServiceInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoGroupsFilter
implements ExtensionObjectFilter {
    private static final String SSO_GROUPS_METADATA_TAG = "requiredSsoGroups";
    private final PropertyInfo[] _filterProperties;
    private final UserSessionServiceInternal _userSessionServiceInternal;

    @Autowired
    public SsoGroupsFilter(UserSessionServiceInternal userSessionServiceInternal) {
        this._userSessionServiceInternal = userSessionServiceInternal;
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = SSO_GROUPS_METADATA_TAG;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        UserSessionSSODomainInfo ssoInfo = this._userSessionServiceInternal.getUserSessionSSODomainInfo();
        String[] groups = ssoInfo.groups;
        String[] systemDomains = ssoInfo.systemDomains;
        for (ExtensionInfo ei : extensionInfos) {
            String requiredSsoGroups = (String)ei.getMetadata().get(SSO_GROUPS_METADATA_TAG);
            String[] requiredGroups = requiredSsoGroups.split(",");
            boolean filteredIn = this.isMemberOf(requiredGroups, groups, systemDomains);
            if (!filteredIn) continue;
            result.add(ei);
        }
        return result;
    }

    private boolean isMemberOf(String[] requiredGroups, String[] groups, String[] systemDomains) {
        for (String reqGroup : requiredGroups) {
            if ((reqGroup = reqGroup.trim()) == "") {
                return true;
            }
            for (String domain : systemDomains) {
                String required = domain + "\\" + reqGroup;
                for (String actualGroup : groups) {
                    if (!actualGroup.equalsIgnoreCase(required)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

