/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.extensionfw.RemotePluginExtensionInfo;
import com.vmware.vise.util.IdVersionPair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemotePluginAggregatingExtensionFilter
implements ExtensionObjectFilter {
    private final ExtensionService _extensionService;

    public RemotePluginAggregatingExtensionFilter(ExtensionService extensionService) {
        this._extensionService = extensionService;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        PluginInfo[] activePluginsInfos;
        if (extensionInfos == null) {
            return null;
        }
        HashSet<IdVersionPair> activePluginsRefs = new HashSet<IdVersionPair>();
        for (PluginInfo activePluginInfo : activePluginsInfos = this._extensionService.getPluginInfos()) {
            activePluginsRefs.add(activePluginInfo.getPluginRef());
        }
        ArrayList<ExtensionInfo> resultExtensionInfos = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : extensionInfos) {
            if (!this.isValidExtensionInfo(extensionInfo, activePluginsRefs)) continue;
            resultExtensionInfos.add(extensionInfo);
        }
        return resultExtensionInfos;
    }

    private boolean isValidExtensionInfo(ExtensionInfo extensionInfo, Set<IdVersionPair> activePluginsRefs) {
        RemotePluginExtensionInfo remotePluginExtensionInfo = extensionInfo.getRemotePluginExtensionInfo();
        if (remotePluginExtensionInfo == null) {
            return true;
        }
        RemotePluginExtensionInfo.RemotePluginExtensionAggregationInfo aggregationInfo = remotePluginExtensionInfo.aggregationInfo;
        if (aggregationInfo == null) {
            return true;
        }
        HashSet activeAggregatedPluginsRefs = new HashSet();
        activeAggregatedPluginsRefs.addAll(remotePluginExtensionInfo.aggregationInfo.aggregatedPackageRefs);
        activeAggregatedPluginsRefs.retainAll(activePluginsRefs);
        boolean hasActiveAggregatedPluginsRefs = !activeAggregatedPluginsRefs.isEmpty();
        return hasActiveAggregatedPluginsRefs;
    }
}

