/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelatedItemsExtensionFilter
implements ExtensionObjectFilter {
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String RELATED_OBJECTS_VIEWID_SUFFIX = "related";
    private final PropertyInfo[] _contextProperties;
    private final RelatedItemsManager _relatedItemsManager;
    private static final Log _logger = LogFactory.getLog(RelatedItemsExtensionFilter.class);

    public RelatedItemsExtensionFilter(RelatedItemsManager relatedItemsManager) {
        this._relatedItemsManager = relatedItemsManager;
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        Object[] contextObjects = this.getContextObjects(filterContext);
        if (contextObjects.length != 1) {
            return extensionInfos;
        }
        Object contextObject = contextObjects[0];
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extInfo : extensionInfos) {
            if (!extInfo.getId().endsWith(RELATED_OBJECTS_VIEWID_SUFFIX)) {
                result.add(extInfo);
                continue;
            }
            try {
                RelatedItemSummary[] relatedItems = this._relatedItemsManager.getRelatedItemsSummary(contextObject, null, false, false, extInfo.getId());
                if (relatedItems.length <= 0) continue;
                result.add(extInfo);
            }
            catch (Exception e) {
                _logger.error((Object)("Error while retrieving RelationSpecs for viewId: " + extInfo.getId()), (Throwable)e);
            }
        }
        return result;
    }

    private Object[] getContextObjects(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        return objectArr;
    }
}

