/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PluginExtensionFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ExtensionService _extensionService;

    public PluginExtensionFilter(ExtensionService extensionService) {
        this._extensionService = extensionService;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        String ctxObjectString = this.getContextObjString(filterContext);
        if (StringUtil.isNullOrEmpty((String)ctxObjectString) || ctxObjectString.equals("NO_OBJECT") || !ctxObjectString.contains("ManagedObjectReference")) {
            return extensionInfos;
        }
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo ei : extensionInfos) {
            PluginInfo pluginInfo = null;
            try {
                pluginInfo = this._extensionService.getPluginInfo(ei.getPluginRef());
            }
            catch (Exception e) {
                _logger.error((Object)("Couldn't find plugin info for: " + pluginInfo));
            }
            if (pluginInfo == null) {
                result.add(ei);
                continue;
            }
            PluginPackageInfo pluginPackageInfo = this._extensionService.getPluginPackageInfo(pluginInfo.getPackageRef());
            if (pluginPackageInfo != null && !this.isValidExtension(ei, pluginInfo.getPluginRef(), pluginPackageInfo, ctxObjectString)) continue;
            result.add(ei);
        }
        return result;
    }

    protected abstract boolean isValidExtension(ExtensionInfo var1, IdVersionPair var2, PluginPackageInfo var3, String var4);

    private String getContextObjString(Map<String, Object> filterContext) {
        if (filterContext == null) {
            return null;
        }
        Object contextObjects = filterContext.get("contextObjects");
        Object contextObject = null;
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        if (objectArr != null && objectArr.length > 0) {
            contextObject = objectArr[0];
        }
        if (contextObject == null) {
            return null;
        }
        return contextObject.toString();
    }
}

