/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.util.PropertyConstraintCompUtil;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ObjectPropertyFilter
implements ExtensionObjectFilter {
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;
    private static final Log _logger = LogFactory.getLog(ObjectPropertyFilter.class);
    private static final String PROPERTY_CONDITIONS = "propertyConditions";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String TYPE = "/@type";
    private static final String NULL_STRING = "null";

    @Autowired
    public ObjectPropertyFilter(QueryServiceFactory queryServiceFactory, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = PROPERTY_CONDITIONS;
        pInfo.type = CompositeConstraint.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        if (filterContext == null) {
            return extensionInfos;
        }
        Object[] objectArr = this.getContextObjects(filterContext);
        if (objectArr.length == 0 || objectArr[0] == null) {
            return extensionInfos;
        }
        String objectType = this._objRefService.getResourceObjectType(objectArr[0]);
        Set<String> propertySet = this.getProperties(extensionInfos);
        if (propertySet.isEmpty()) {
            if (!this.objectsExist(objectArr, objectType)) {
                return Collections.emptyList();
            }
            return extensionInfos;
        }
        propertySet.add("@modelKey");
        String[] propertiesToFetch = this.extractPropertiesToFetch(objectArr, propertySet);
        if (propertiesToFetch.length == 0) {
            return extensionInfos;
        }
        List<ExtensionInfo> result = null;
        try {
            ResultSet resultSet = this._queryService.select(propertiesToFetch).from(new String[]{objectType}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objectArr)).fetch();
            Collection<ObjectRefPropertyValueHolder> objectPropertyValueList = this.createObjectPropertyValueList(resultSet);
            result = this.applyObjectData(extensionInfos, objectPropertyValueList);
        }
        catch (Exception e) {
            result = extensionInfos;
            if (this.isNoPermission(e)) {
                return result;
            }
            _logger.error((Object)"Error when doing filter based on object properties ", (Throwable)e);
        }
        return result;
    }

    private boolean isNoPermission(Exception e) {
        Throwable cause = e.getCause();
        return cause != null && cause instanceof DataException && ((DataException)cause).rootCause instanceof NoPermission;
    }

    private Object[] getContextObjects(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        return objectArr;
    }

    private Set<String> getProperties(List<ExtensionInfo> extensionInfos) {
        HashSet<String> propertySet = new HashSet<String>();
        for (ExtensionInfo ei : extensionInfos) {
            List<PropertyConstraint> propertyConstraints = this.extractPropertyConstraints(ei);
            if (propertyConstraints == null) {
                _logger.error((Object)("Invalid metadata for extension info:" + ei.getId()));
                continue;
            }
            propertySet.addAll(this.extractPropertyNames(propertyConstraints));
        }
        return propertySet;
    }

    private Collection<ObjectRefPropertyValueHolder> createObjectPropertyValueList(ResultSet resultSet) {
        ArrayList<ObjectRefPropertyValueHolder> result = new ArrayList<ObjectRefPropertyValueHolder>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object objRef = resourceItem.getKey();
            ObjectRefPropertyValueHolder objectPropValueHolder = new ObjectRefPropertyValueHolder(objRef);
            result.add(objectPropValueHolder);
            for (String property : resultSet.getProperties()) {
                objectPropValueHolder.addPropertyValue(property, resourceItem.get(property));
            }
        }
        return result;
    }

    private Set<String> extractPropertyNames(List<PropertyConstraint> propertyConstraints) {
        if (propertyConstraints == null) {
            return null;
        }
        HashSet<String> propertyNames = new HashSet<String>(propertyConstraints.size());
        for (PropertyConstraint propertyConstraint : propertyConstraints) {
            String propertyName = propertyConstraint.propertyName;
            if (StringUtil.isNullOrEmpty((String)propertyName)) continue;
            int index = propertyName.indexOf(TYPE);
            if (index >= 0) {
                propertyName = propertyName.substring(0, index);
            }
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    private List<PropertyConstraint> extractPropertyConstraints(ExtensionInfo extensionInfo) {
        ArrayList<PropertyConstraint> propertyConstraints = null;
        CompositeConstraint compositeConstraint = this.extractCompositeConstraint(extensionInfo);
        if (compositeConstraint == null || compositeConstraint.nestedConstraints == null) {
            return propertyConstraints;
        }
        propertyConstraints = new ArrayList<PropertyConstraint>(compositeConstraint.nestedConstraints.length);
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            if (!(constraint instanceof PropertyConstraint)) continue;
            PropertyConstraint propCons = (PropertyConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)propCons.propertyName)) continue;
            propertyConstraints.add(propCons);
        }
        return propertyConstraints;
    }

    private CompositeConstraint extractCompositeConstraint(ExtensionInfo extensionInfo) {
        if (extensionInfo.getMetadata() == null) {
            return null;
        }
        return (CompositeConstraint)extensionInfo.getMetadata().get(PROPERTY_CONDITIONS);
    }

    private Conjoiner extractComparisonConjoiner(ExtensionInfo extensionInfo) {
        CompositeConstraint compositeConstraint = this.extractCompositeConstraint(extensionInfo);
        if (compositeConstraint == null || compositeConstraint.conjoiner == null) {
            return Conjoiner.AND;
        }
        return compositeConstraint.conjoiner;
    }

    private String[] extractPropertiesToFetch(Object[] objects, Set<String> properties) {
        String[] propertiesToFetch = new String[]{};
        Object object = objects[0];
        if (object == null) {
            return propertiesToFetch;
        }
        propertiesToFetch = new String[properties.size()];
        int idx = 0;
        for (String property : properties) {
            propertiesToFetch[idx++] = property;
        }
        return propertiesToFetch;
    }

    private List<ExtensionInfo> applyObjectData(List<ExtensionInfo> extensionInfos, Collection<ObjectRefPropertyValueHolder> objectData) {
        ArrayList<ExtensionInfo> passedExtensions = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : extensionInfos) {
            Conjoiner comparisonConjoiner;
            List<PropertyConstraint> propertyConstraints = this.extractPropertyConstraints(extensionInfo);
            boolean comparisonSucceeded = this.computeComparisonsForObjects(objectData, propertyConstraints, comparisonConjoiner = this.extractComparisonConjoiner(extensionInfo));
            if (!comparisonSucceeded) continue;
            passedExtensions.add(extensionInfo);
        }
        return passedExtensions;
    }

    private boolean computeANDedComparisons(ObjectRefPropertyValueHolder comparableObject, List<PropertyConstraint> propertyConstraints) {
        boolean conjoinerResult = true;
        for (PropertyConstraint propertyConstraint : propertyConstraints) {
            if (conjoinerResult &= this.computeComparisonForObject(comparableObject, propertyConstraint)) continue;
            return false;
        }
        return true;
    }

    private boolean computeORedComparisons(ObjectRefPropertyValueHolder comparableObject, List<PropertyConstraint> propertyConstraints) {
        boolean conjoinerResult = false;
        for (PropertyConstraint propertyConstraint : propertyConstraints) {
            if (!(conjoinerResult |= this.computeComparisonForObject(comparableObject, propertyConstraint))) continue;
            return true;
        }
        return false;
    }

    private boolean computeComparisonsForObjects(Collection<ObjectRefPropertyValueHolder> comparableObjects, List<PropertyConstraint> propertyConstraints, Conjoiner comparisonConjoiner) {
        for (ObjectRefPropertyValueHolder objDataObj : comparableObjects) {
            boolean comparisonsSuccesful = this.computeComparisonsForObject(objDataObj, propertyConstraints, comparisonConjoiner);
            if (comparisonsSuccesful) continue;
            return false;
        }
        return true;
    }

    private boolean computeComparisonsForObject(ObjectRefPropertyValueHolder comparableObject, List<PropertyConstraint> propertyConstraints, Conjoiner comparisonConjoiner) {
        if (comparisonConjoiner == Conjoiner.AND) {
            return this.computeANDedComparisons(comparableObject, propertyConstraints);
        }
        if (comparisonConjoiner == Conjoiner.OR) {
            return this.computeORedComparisons(comparableObject, propertyConstraints);
        }
        return false;
    }

    private boolean computeComparisonForObject(ObjectRefPropertyValueHolder comparableObject, PropertyConstraint propertyConstraint) {
        String propertyName = propertyConstraint.propertyName;
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            return false;
        }
        Object actualValue = this.extractPropertyValue(comparableObject, propertyName);
        Object expectedValue = propertyConstraint.comparableValue;
        if (expectedValue != null && expectedValue.toString().equalsIgnoreCase(NULL_STRING)) {
            expectedValue = null;
        }
        return PropertyConstraintCompUtil.matchValues((Object)actualValue, (Object)expectedValue, (Comparator)propertyConstraint.comparator);
    }

    private Object extractPropertyValue(ObjectRefPropertyValueHolder objectPropertyHolder, String propertyName) {
        Object objRef = objectPropertyHolder.getSourceObject();
        Object actualValue = null;
        if (objRef == null) {
            return actualValue;
        }
        Map propValueMap = objectPropertyHolder.getPropertyValueMap();
        if (propValueMap == null) {
            return actualValue;
        }
        int index = propertyName.indexOf(TYPE);
        if (index >= 0) {
            Object sourceObj = propValueMap.get(propertyName = propertyName.substring(0, index));
            if (sourceObj != null) {
                actualValue = this._objRefService.getResourceObjectType(sourceObj);
            }
        } else {
            Object object = actualValue = propValueMap.get(propertyName) != null ? (Object)propValueMap.get(propertyName) : null;
        }
        if (actualValue != null && actualValue.getClass().isEnum()) {
            actualValue = ((Enum)actualValue).name();
        }
        return actualValue;
    }

    private boolean objectsExist(Object[] objects, String objectType) {
        ResultSet result = this._queryService.select(new String[0]).from(new String[]{objectType}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objects)).withTotalCount().fetch();
        return result.getTotalCount() > 0;
    }

    private static class ObjectRefPropertyValueHolder {
        final Object _sourceObject;
        Map<String, Object> _propertyValueMap;

        private ObjectRefPropertyValueHolder(Object _sourceObject) {
            this._sourceObject = _sourceObject;
        }

        private Object getSourceObject() {
            return this._sourceObject;
        }

        private Map<String, Object> getPropertyValueMap() {
            return this._propertyValueMap;
        }

        private void addPropertyValue(String key, Object value) {
            if (this._propertyValueMap == null) {
                this._propertyValueMap = new HashMap<String, Object>();
            }
            this._propertyValueMap.put(key, value);
        }
    }
}

