/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultipleTargetsOnlyFilter
implements ExtensionObjectFilter {
    private static final String REQUIRES_MULTIPLE_TARGETS = "requiresMultipleTargets";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;

    public MultipleTargetsOnlyFilter() {
        PropertyInfo filterProp = new PropertyInfo();
        filterProp.name = REQUIRES_MULTIPLE_TARGETS;
        filterProp.type = Boolean.class.getName();
        filterProp.optional = false;
        this._filterProperties = new PropertyInfo[]{filterProp};
        PropertyInfo contextProp = new PropertyInfo();
        contextProp.name = CONTEXT_OBJECTS;
        contextProp.type = Object[].class.getName();
        contextProp.optional = false;
        this._contextProperties = new PropertyInfo[]{contextProp};
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        Object[] contextObjects = this.getContextObjects(filterContext);
        if (contextObjects.length > 1) {
            return extensionInfos;
        }
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo ei : extensionInfos) {
            Boolean onlyMultipleTargets = (Boolean)ei.getMetadata().get(REQUIRES_MULTIPLE_TARGETS);
            if (onlyMultipleTargets != null && onlyMultipleTargets.booleanValue()) continue;
            result.add(ei);
        }
        return result;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    private Object[] getContextObjects(Map<String, Object> filterContext) {
        Object contextObjects = filterContext.get(CONTEXT_OBJECTS);
        Object[] objectArr = contextObjects instanceof Object[] ? (Object[])contextObjects : new Object[]{contextObjects};
        return objectArr;
    }
}

