/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionHostFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(ExtensionHostFilter.class);
    private static final String REQUIRES_HOSTED_EXTENSIONS = "requiresHostedExtensions";
    private final PropertyInfo[] _filterProperties;
    private ExtensionService _extensionService;

    public ExtensionHostFilter(ExtensionService extensionService) {
        this._extensionService = extensionService;
        PropertyInfo filterProp = new PropertyInfo();
        filterProp.name = REQUIRES_HOSTED_EXTENSIONS;
        filterProp.type = Boolean.class.getName();
        filterProp.optional = false;
        this._filterProperties = new PropertyInfo[]{filterProp};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        block0: for (ExtensionInfo ei : extensionInfos) {
            Boolean requiresHostedExtensions = (Boolean)ei.getMetadata().get(REQUIRES_HOSTED_EXTENSIONS);
            if (requiresHostedExtensions == null || !requiresHostedExtensions.booleanValue()) {
                result.add(ei);
                continue;
            }
            Object[] hostedPoints = ei.getHostedPointsIds();
            if (ArrayUtil.isNullOrEmpty((Object[])hostedPoints)) {
                _logger.error((Object)("ExtensionHostFilter: Extension with id '" + ei.getId() + "' should specify at least 1 hostedPoint."));
                continue;
            }
            for (Object pointId : hostedPoints) {
                List hostExtensionObjects = this._extensionService.getExtensionObjects((String)pointId, filterContext, false);
                if (hostExtensionObjects == null || hostExtensionObjects.isEmpty()) continue;
                result.add(ei);
                continue block0;
            }
        }
        return result;
    }
}

