/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigurationFilter
implements ExtensionObjectFilter {
    private static final String CONFIGURATION_PROPERTY_TAG = "configuration";
    private static final String NEGATION = "!";
    private final PropertyInfo[] _filterProperties;
    private ConfigurationService _configurationService;

    public ConfigurationFilter(ConfigurationService configurationService) {
        this._configurationService = configurationService;
        PropertyInfo pInfo = new PropertyInfo();
        pInfo.name = CONFIGURATION_PROPERTY_TAG;
        pInfo.type = String.class.getName();
        pInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{pInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        ArrayList<ExtensionInfo> filteredExtensions = new ArrayList<ExtensionInfo>(extensionInfos.size());
        for (ExtensionInfo extension : extensionInfos) {
            String configPropValue;
            Boolean isConfigPropEnabled;
            String configFilterValue = (String)extension.getMetadata().get(CONFIGURATION_PROPERTY_TAG);
            boolean isNegated = false;
            if (configFilterValue != null && configFilterValue.trim().startsWith(NEGATION)) {
                isNegated = true;
                configFilterValue = configFilterValue.substring(1);
            }
            if (!(isNegated ^ ((isConfigPropEnabled = StringUtil.parseBoolean((String)(configPropValue = this._configurationService.getProperty(configFilterValue)))) != null && isConfigPropEnabled != false))) continue;
            filteredExtensions.add(extension);
        }
        return filteredExtensions;
    }
}

