/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.common.collect.ImmutableMap;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vsphere.client.usersession.UserSessionInfo;
import com.vmware.vsphere.client.usersession.UserSessionSSODomainInfo;
import com.vmware.vsphere.client.usersession.UserSessionServerInfo;
import com.vmware.vsphere.client.usersession.UserSessionServiceInternal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/usersession"}, method={RequestMethod.GET})
public class UserSessionController {
    private final AtomicReference<UserSessionServiceInternal> _userSessionServiceRef = new AtomicReference();
    private final ServiceRegistry _serviceRegistry;
    private static final Log _logger = LogFactory.getLog(UserSessionController.class);
    private static final Map<String, String> SERVER_ERROR_MESSAGES = ImmutableMap.of((Object)"connectError", (Object)"error.peerVcConnectionError", (Object)"sslError", (Object)"error.vcSslError", (Object)"sspiError", (Object)"error.vcSspiError", (Object)"invalidCredentials", (Object)"error.vcInvalidCredentials", (Object)"compatibilityError", (Object)"error.incompatibleVcs");

    @Autowired
    public UserSessionController(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
    }

    @RequestMapping
    @ResponseBody
    public UserSessionInfo getUserSessionInfo() {
        UserSessionInfo result = this.getUserSessionInfoInternal();
        return result;
    }

    @RequestMapping(value={"/ping"})
    @ResponseBody
    public void ping() {
        UserSessionServiceInternal userSessionService = this.getUserSessionService();
        if (userSessionService != null) {
            userSessionService.ping();
        } else {
            _logger.warn((Object)"No-op on ping operation, since userSessionService is un-available.");
        }
    }

    @RequestMapping(value={"/serverInfo"})
    @ResponseBody
    public UserSessionServerInfo getUserSessionServerInfo() {
        UserSessionServiceInternal userSessionService = this.getUserSessionService();
        return userSessionService.getUserSessionServerInfo();
    }

    @RequestMapping(value={"/userSessionServerErrors"})
    @ResponseBody
    public String[] getUserSessionErrors() {
        UserSessionServiceInternal userSessionService = this.getUserSessionService();
        UserSessionServerInfo userSessionServerInfos = userSessionService.getUserSessionServerInfo();
        if (userSessionServerInfos == null) {
            _logger.error((Object)"Error when getting user sesion info. The user session does not exists or the user has been logged out.");
            return new String[0];
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (ServerInfo serverInfo : userSessionServerInfos.serversInfo) {
            if (!(serverInfo instanceof ServerInfoEx)) continue;
            ServerInfoEx serverInfoEx = (ServerInfoEx)serverInfo;
            String errorCode = serverInfoEx.errorCode;
            String errStr = SERVER_ERROR_MESSAGES.get(errorCode);
            if (errStr == null) continue;
            errorMessages.add(CommonUtils.text(errStr, serverInfoEx.serviceUrl));
        }
        return errorMessages.toArray(new String[0]);
    }

    @RequestMapping(value={"/ssoDomainInfo"})
    @ResponseBody
    public UserSessionSSODomainInfo getUserSessionSSODomainInfo() {
        UserSessionServiceInternal userSessionService = this.getUserSessionService();
        return userSessionService.getUserSessionSSODomainInfo();
    }

    private UserSessionInfo getUserSessionInfoInternal() {
        UserSessionServiceInternal userSessionService = this.getUserSessionService();
        return userSessionService.getUserSessionInfo();
    }

    private UserSessionServiceInternal getUserSessionService() {
        UserSessionServiceInternal userSessionService = this._userSessionServiceRef.get();
        if (userSessionService == null) {
            UserSessionServiceInternal uss = null;
            try {
                uss = (UserSessionServiceInternal)this._serviceRegistry.getService(UserSessionServiceInternal.class.getName());
            }
            catch (Exception e) {
                _logger.error((Object)("Error when getting service of UserSessionService interface" + e.getMessage()));
                return null;
            }
            boolean success = this._userSessionServiceRef.compareAndSet(null, uss);
            if (success) {
                Assert.notNull((Object)uss, (String)"UserSessionService should not be null from the service registry");
                return uss;
            }
            userSessionService = this._userSessionServiceRef.get();
        }
        Validate.notNull((Object)userSessionService, (String)"UserSessionService should not be null", (Object[])new Object[0]);
        return userSessionService;
    }
}

