/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tree"})
public class TreeController {
    private final TreeManager _treeManager;

    @Autowired
    public TreeController(TreeManager treeManager) {
        this._treeManager = treeManager;
    }

    @ResponseBody
    @RequestMapping(value={"/root"})
    public List<TreeNodeItem> getRoot(@RequestParam(value="treeId") String treeId, @RequestParam(value="objRef", required=false) String objRef) {
        List<TreeNodeItem> result = this._treeManager.getRoot(treeId, objRef);
        return result;
    }

    @RequestMapping(value={"/children"})
    @ResponseBody
    public List<TreeNodeItem> getChildren(@RequestParam(value="treeId") String treeId, @RequestParam(value="nodeTypeId") String nodeTypeId, @RequestParam(value="objRef") String objRef) {
        List<TreeNodeItem> result = this._treeManager.getChildren(treeId, nodeTypeId, objRef);
        return result;
    }

    @RequestMapping(value={"/childrenByObjectIds"}, method={RequestMethod.POST})
    public Map<String, List<TreeNodeItem>> getChildrenByObjectIds(@RequestBody Map<String, Object> args) throws Exception {
        List parents;
        String treeId;
        try {
            treeId = (String)args.get("treeId");
            parents = (List)args.get("parents");
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Wrong layout for treeId or parents.");
        }
        Validate.notNull((Object)treeId);
        Validate.notNull((Object)parents);
        HashMap<String, List<TreeNodeItem>> childrenByObjectIds = new HashMap<String, List<TreeNodeItem>>(parents.size());
        for (Map parent : parents) {
            String nodeTypeId = (String)parent.get("nodeTypeId");
            String objRef = (String)parent.get("objRef");
            Validate.notNull((Object)nodeTypeId);
            Validate.notNull((Object)objRef);
            childrenByObjectIds.put(objRef, this._treeManager.getChildren(treeId, nodeTypeId, objRef));
        }
        return childrenByObjectIds;
    }

    @RequestMapping(value={"/path"})
    @ResponseBody
    public TreePath getPath(@RequestParam(value="treeId") String treeId, @RequestParam(value="rootRef", required=false) String rootRef, @RequestParam(value="objRef") String objRef, @RequestParam(value="options", required=false) String options) {
        TreePath result = this._treeManager.getPath(treeId, rootRef, objRef, options);
        return result;
    }

    @RequestMapping(value={"/propertiesByObjectIds"}, method={RequestMethod.POST})
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(@RequestBody Map<String, ArrayList<String>> args) throws Exception {
        List objectIds = args.get("objectIds");
        Validate.notNull((Object)objectIds);
        Map<String, Map<String, Object>> result = this._treeManager.getPropertiesByObjectIds(objectIds);
        return result;
    }

    @RequestMapping(value={"/supportedTypes"})
    @ResponseBody
    public List<String> getSupportedTypes(@RequestParam(value="treeId") String treeId) {
        List<String> result = this._treeManager.getSupportedTypes(treeId);
        return result;
    }
}

