/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.extensionfw.PluginExtensionManager;
import com.vmware.vise.extensionfw.PluginStyleManager;
import com.vmware.vise.extensionfw.RemotePluginSessionRegistry;
import com.vmware.vise.mvc.model.PluginInstanceSessionInfo;
import com.vmware.vise.usersession.UserSessionService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PluginServiceController {
    private static final Log _logger = LogFactory.getLog(PluginServiceController.class);
    private final UserSessionService _userSessionService;
    private final RemotePluginSessionRegistry _pluginSessionRegistry;
    private final PluginExtensionManager _pluginExtensionManager;
    private final PluginStyleManager _pluginStyleManager;

    @Autowired
    public PluginServiceController(UserSessionService userSessionService, RemotePluginSessionRegistry pluginSessionRegistry, PluginExtensionManager pluginExtensionManager, PluginStyleManager pluginStyleManager) {
        this._userSessionService = userSessionService;
        this._pluginSessionRegistry = pluginSessionRegistry;
        this._pluginExtensionManager = pluginExtensionManager;
        this._pluginStyleManager = pluginStyleManager;
    }

    @RequestMapping(value={"/plugins/css"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getAllJsonPluginsCss() throws Exception {
        String allJsonPluginsCss = this._pluginStyleManager.getAllPluginsStyleSheet();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/css"})).body((Object)allJsonPluginsCss);
    }

    @RequestMapping(value={"/plugins/{fqpiId}/session"}, method={RequestMethod.GET})
    @ResponseBody
    public PluginInstanceSessionInfo getPluginInstanceSessionInfo(@PathVariable(value="fqpiId") String instanceRef) throws Exception {
        _logger.info((Object)("Fetching session for remote plugin with ref " + instanceRef));
        String clientId = this._userSessionService.getUserSession().clientId;
        String token = this._pluginSessionRegistry.acquireSessionToken(clientId, instanceRef);
        PluginInstanceSessionInfo sessionInfo = new PluginInstanceSessionInfo();
        sessionInfo.sessionToken = token;
        return sessionInfo;
    }

    @RequestMapping(value={"/plugins/standardExtensionIdToSharedExtensionIdMap"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getStandardExtensionIdToSharedExtensionIdMap() {
        return this._pluginExtensionManager.getStandardExtensionIdToSharedExtensionIdMap();
    }
}

